% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_get_streaming_distribution}
\alias{cloudfront_get_streaming_distribution}
\title{Gets information about a specified RTMP distribution, including the
distribution configuration}
\usage{
cloudfront_get_streaming_distribution(Id)
}
\arguments{
\item{Id}{[required] The streaming distribution's ID.}
}
\value{
A list with the following syntax:\preformatted{list(
  StreamingDistribution = list(
    Id = "string",
    ARN = "string",
    Status = "string",
    LastModifiedTime = as.POSIXct(
      "2015-01-01"
    ),
    DomainName = "string",
    ActiveTrustedSigners = list(
      Enabled = TRUE|FALSE,
      Quantity = 123,
      Items = list(
        list(
          AwsAccountNumber = "string",
          KeyPairIds = list(
            Quantity = 123,
            Items = list(
              "string"
            )
          )
        )
      )
    ),
    StreamingDistributionConfig = list(
      CallerReference = "string",
      S3Origin = list(
        DomainName = "string",
        OriginAccessIdentity = "string"
      ),
      Aliases = list(
        Quantity = 123,
        Items = list(
          "string"
        )
      ),
      Comment = "string",
      Logging = list(
        Enabled = TRUE|FALSE,
        Bucket = "string",
        Prefix = "string"
      ),
      TrustedSigners = list(
        Enabled = TRUE|FALSE,
        Quantity = 123,
        Items = list(
          "string"
        )
      ),
      PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
      Enabled = TRUE|FALSE
    )
  ),
  ETag = "string"
)
}
}
\description{
Gets information about a specified RTMP distribution, including the
distribution configuration.
}
\section{Request syntax}{
\preformatted{svc$get_streaming_distribution(
  Id = "string"
)
}
}

\keyword{internal}
