% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_get_origin_request_policy_config}
\alias{cloudfront_get_origin_request_policy_config}
\title{Gets an origin request policy configuration}
\usage{
cloudfront_get_origin_request_policy_config(Id)
}
\arguments{
\item{Id}{[required] The unique identifier for the origin request policy. If the origin
request policy is attached to a distribution’s cache behavior, you can
get the policy’s identifier using
\code{\link[=cloudfront_list_distributions]{list_distributions}} or
\code{\link[=cloudfront_get_distribution]{get_distribution}}. If the origin request
policy is not attached to a cache behavior, you can get the identifier
using
\code{\link[=cloudfront_list_origin_request_policies]{list_origin_request_policies}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  OriginRequestPolicyConfig = list(
    Comment = "string",
    Name = "string",
    HeadersConfig = list(
      HeaderBehavior = "none"|"whitelist"|"allViewer"|"allViewerAndWhitelistCloudFront",
      Headers = list(
        Quantity = 123,
        Items = list(
          "string"
        )
      )
    ),
    CookiesConfig = list(
      CookieBehavior = "none"|"whitelist"|"all",
      Cookies = list(
        Quantity = 123,
        Items = list(
          "string"
        )
      )
    ),
    QueryStringsConfig = list(
      QueryStringBehavior = "none"|"whitelist"|"all",
      QueryStrings = list(
        Quantity = 123,
        Items = list(
          "string"
        )
      )
    )
  ),
  ETag = "string"
)
}
}
\description{
Gets an origin request policy configuration.

To get an origin request policy configuration, you must provide the
policy’s identifier. If the origin request policy is attached to a
distribution’s cache behavior, you can get the policy’s identifier using
\code{\link[=cloudfront_list_distributions]{list_distributions}} or
\code{\link[=cloudfront_get_distribution]{get_distribution}}. If the origin request
policy is not attached to a cache behavior, you can get the identifier
using
\code{\link[=cloudfront_list_origin_request_policies]{list_origin_request_policies}}.
}
\section{Request syntax}{
\preformatted{svc$get_origin_request_policy_config(
  Id = "string"
)
}
}

\keyword{internal}
