% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_describe_gateway_route}
\alias{appmesh_describe_gateway_route}
\title{Describes an existing gateway route}
\usage{
appmesh_describe_gateway_route(gatewayRouteName, meshName, meshOwner,
  virtualGatewayName)
}
\arguments{
\item{gatewayRouteName}{[required] The name of the gateway route to describe.}

\item{meshName}{[required] The name of the service mesh that the gateway route resides in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it's the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{virtualGatewayName}{[required] The name of the virtual gateway that the gateway route is associated
with.}
}
\value{
A list with the following syntax:\preformatted{list(
  gatewayRoute = list(
    gatewayRouteName = "string",
    meshName = "string",
    metadata = list(
      arn = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      meshOwner = "string",
      resourceOwner = "string",
      uid = "string",
      version = 123
    ),
    spec = list(
      grpcRoute = list(
        action = list(
          target = list(
            virtualService = list(
              virtualServiceName = "string"
            )
          )
        ),
        match = list(
          serviceName = "string"
        )
      ),
      http2Route = list(
        action = list(
          target = list(
            virtualService = list(
              virtualServiceName = "string"
            )
          )
        ),
        match = list(
          prefix = "string"
        )
      ),
      httpRoute = list(
        action = list(
          target = list(
            virtualService = list(
              virtualServiceName = "string"
            )
          )
        ),
        match = list(
          prefix = "string"
        )
      )
    ),
    status = list(
      status = "ACTIVE"|"INACTIVE"|"DELETED"
    ),
    virtualGatewayName = "string"
  )
)
}
}
\description{
Describes an existing gateway route.
}
\section{Request syntax}{
\preformatted{svc$describe_gateway_route(
  gatewayRouteName = "string",
  meshName = "string",
  meshOwner = "string",
  virtualGatewayName = "string"
)
}
}

\keyword{internal}
