% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmincidents_operations.R
\name{ssmincidents_create_response_plan}
\alias{ssmincidents_create_response_plan}
\title{Creates a response plan that automates the initial response to incidents}
\usage{
ssmincidents_create_response_plan(
  actions = NULL,
  chatChannel = NULL,
  clientToken = NULL,
  displayName = NULL,
  engagements = NULL,
  incidentTemplate,
  integrations = NULL,
  name,
  tags = NULL
)
}
\arguments{
\item{actions}{The actions that the response plan starts at the beginning of an
incident.}

\item{chatChannel}{The Chatbot chat channel used for collaboration during an incident.}

\item{clientToken}{A token ensuring that the operation is called only once with the
specified details.}

\item{displayName}{The long format of the response plan name. This field can contain
spaces.}

\item{engagements}{The Amazon Resource Name (ARN) for the contacts and escalation plans
that the response plan engages during an incident.}

\item{incidentTemplate}{[required] Details used to create an incident when using this response plan.}

\item{integrations}{Information about third-party services integrated into the response
plan.}

\item{name}{[required] The short format name of the response plan. Can't include spaces.}

\item{tags}{A list of tags that you are adding to the response plan.}
}
\description{
Creates a response plan that automates the initial response to incidents. A response plan engages contacts, starts chat channel collaboration, and initiates runbooks at the beginning of an incident.

See \url{https://www.paws-r-sdk.com/docs/ssmincidents_create_response_plan/} for full documentation.
}
\keyword{internal}
