% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_association}
\alias{ssm_update_association}
\title{Updates an association}
\usage{
ssm_update_association(
  AssociationId,
  Parameters = NULL,
  DocumentVersion = NULL,
  ScheduleExpression = NULL,
  OutputLocation = NULL,
  Name = NULL,
  Targets = NULL,
  AssociationName = NULL,
  AssociationVersion = NULL,
  AutomationTargetParameterName = NULL,
  MaxErrors = NULL,
  MaxConcurrency = NULL,
  ComplianceSeverity = NULL,
  SyncCompliance = NULL,
  ApplyOnlyAtCronInterval = NULL,
  CalendarNames = NULL,
  TargetLocations = NULL,
  ScheduleOffset = NULL,
  TargetMaps = NULL,
  AlarmConfiguration = NULL
)
}
\arguments{
\item{AssociationId}{[required] The ID of the association you want to update.}

\item{Parameters}{The parameters you want to update for the association. If you create a
parameter using Parameter Store, a capability of Amazon Web Services
Systems Manager, you can reference the parameter using
\code{{{ssm:parameter-name}}}.}

\item{DocumentVersion}{The document version you want update for the association.

State Manager doesn't support running associations that use a new
version of a document if that document is shared from another account.
State Manager always runs the \code{default} version of a document if shared
from another account, even though the Systems Manager console shows that
a new version was processed. If you want to run an association using a
new version of a document shared form another account, you must set the
document version to \code{default}.}

\item{ScheduleExpression}{The cron expression used to schedule the association that you want to
update.}

\item{OutputLocation}{An S3 bucket where you want to store the results of this request.}

\item{Name}{The name of the SSM Command document or Automation runbook that contains
the configuration information for the managed node.

You can specify Amazon Web Services-predefined documents, documents you
created, or a document that is shared with you from another account.

For Systems Manager document (SSM document) that are shared with you
from other Amazon Web Services accounts, you must specify the complete
SSM document ARN, in the following format:

\code{arn:aws:ssm:region:account-id:document/document-name }

For example:

\code{arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document}

For Amazon Web Services-predefined documents and SSM documents you
created in your account, you only need to specify the document name. For
example, \code{AWS-ApplyPatchBaseline} or \code{My-Document}.}

\item{Targets}{The targets of the association.}

\item{AssociationName}{The name of the association that you want to update.}

\item{AssociationVersion}{This parameter is provided for concurrency control purposes. You must
specify the latest association version in the service. If you want to
ensure that this request succeeds, either specify \verb{$LATEST}, or omit
this parameter.}

\item{AutomationTargetParameterName}{Choose the parameter that will define how your automation will branch
out. This target is required for associations that use an Automation
runbook and target resources by using rate controls. Automation is a
capability of Amazon Web Services Systems Manager.}

\item{MaxErrors}{The number of errors that are allowed before the system stops sending
requests to run the association on additional targets. You can specify
either an absolute number of errors, for example 10, or a percentage of
the target set, for example 10\%. If you specify 3, for example, the
system stops sending requests when the fourth error is received. If you
specify 0, then the system stops sending requests after the first error
is returned. If you run an association on 50 managed nodes and set
\code{MaxError} to 10\%, then the system stops sending the request when the
sixth error is received.

Executions that are already running an association when \code{MaxErrors} is
reached are allowed to complete, but some of these executions may fail
as well. If you need to ensure that there won't be more than max-errors
failed executions, set \code{MaxConcurrency} to 1 so that executions proceed
one at a time.}

\item{MaxConcurrency}{The maximum number of targets allowed to run the association at the same
time. You can specify a number, for example 10, or a percentage of the
target set, for example 10\%. The default value is 100\%, which means all
targets run the association at the same time.

If a new managed node starts and attempts to run an association while
Systems Manager is running \code{MaxConcurrency} associations, the
association is allowed to run. During the next association interval, the
new managed node will process its association within the limit specified
for \code{MaxConcurrency}.}

\item{ComplianceSeverity}{The severity level to assign to the association.}

\item{SyncCompliance}{The mode for generating association compliance. You can specify \code{AUTO}
or \code{MANUAL}. In \code{AUTO} mode, the system uses the status of the
association execution to determine the compliance status. If the
association execution runs successfully, then the association is
\code{COMPLIANT}. If the association execution doesn't run successfully, the
association is \code{NON-COMPLIANT}.

In \code{MANUAL} mode, you must specify the \code{AssociationId} as a parameter
for the \code{\link[=ssm_put_compliance_items]{put_compliance_items}} API
operation. In this case, compliance data isn't managed by State Manager,
a capability of Amazon Web Services Systems Manager. It is managed by
your direct call to the
\code{\link[=ssm_put_compliance_items]{put_compliance_items}} API operation.

By default, all associations use \code{AUTO} mode.}

\item{ApplyOnlyAtCronInterval}{By default, when you update an association, the system runs it
immediately after it is updated and then according to the schedule you
specified. Specify this option if you don't want an association to run
immediately after you update it. This parameter isn't supported for rate
expressions.

If you chose this option when you created an association and later you
edit that association or you make changes to the SSM document on which
that association is based (by using the Documents page in the console),
State Manager applies the association at the next specified cron
interval. For example, if you chose the \code{Latest} version of an SSM
document when you created an association and you edit the association by
choosing a different document version on the Documents page, State
Manager applies the association at the next specified cron interval if
you previously selected this option. If this option wasn't selected,
State Manager immediately runs the association.

You can reset this option. To do so, specify the
\code{no-apply-only-at-cron-interval} parameter when you update the
association from the command line. This parameter forces the association
to run immediately after updating it and according to the interval
specified.}

\item{CalendarNames}{The names or Amazon Resource Names (ARNs) of the Change Calendar type
documents you want to gate your associations under. The associations
only run when that change calendar is open. For more information, see
\href{https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html}{Amazon Web Services Systems Manager Change Calendar}.}

\item{TargetLocations}{A location is a combination of Amazon Web Services Regions and Amazon
Web Services accounts where you want to run the association. Use this
action to update an association in multiple Regions and multiple
accounts.}

\item{ScheduleOffset}{Number of days to wait after the scheduled day to run an association.
For example, if you specified a cron schedule of
\verb{cron(0 0 ? * THU#2 *)}, you could specify an offset of 3 to run the
association each Sunday after the second Thursday of the month. For more
information about cron schedules for associations, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html}{Reference: Cron and rate expressions for Systems Manager}
in the \emph{Amazon Web Services Systems Manager User Guide}.

To use offsets, you must specify the \code{ApplyOnlyAtCronInterval}
parameter. This option tells the system not to run an association
immediately after you create it.}

\item{TargetMaps}{A key-value mapping of document parameters to target resources. Both
Targets and TargetMaps can't be specified together.}

\item{AlarmConfiguration}{}
}
\description{
Updates an association. You can update the association name and version, the document version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output. When you call \code{\link[=ssm_update_association]{update_association}}, the system removes all optional parameters from the request and overwrites the association with null values for those parameters. This is by design. You must specify all optional parameters in the call, even if you are not changing the parameters. This includes the \code{Name} parameter. Before calling this API action, we recommend that you call the \code{\link[=ssm_describe_association]{describe_association}} API operation and make a note of all optional parameters required for your \code{\link[=ssm_update_association]{update_association}} call.

See \url{https://www.paws-r-sdk.com/docs/ssm_update_association/} for full documentation.
}
\keyword{internal}
