% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_sessions}
\alias{ssm_describe_sessions}
\title{Retrieves a list of all active sessions (both connected and
disconnected) or terminated sessions from the past 30 days}
\usage{
ssm_describe_sessions(
  State,
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL
)
}
\arguments{
\item{State}{[required] The session status to retrieve a list of sessions for. For example,
"Active".}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{Filters}{One or more filters to limit the type of sessions returned by the
request.}
}
\description{
Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30 days.

See \url{https://www.paws-r-sdk.com/docs/ssm_describe_sessions/} for full documentation.
}
\keyword{internal}
