% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_create_product}
\alias{servicecatalog_create_product}
\title{Creates a product}
\usage{
servicecatalog_create_product(
  AcceptLanguage = NULL,
  Name,
  Owner,
  Description = NULL,
  Distributor = NULL,
  SupportDescription = NULL,
  SupportEmail = NULL,
  SupportUrl = NULL,
  ProductType,
  Tags = NULL,
  ProvisioningArtifactParameters = NULL,
  IdempotencyToken,
  SourceConnection = NULL
)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{Name}{[required] The name of the product.}

\item{Owner}{[required] The owner of the product.}

\item{Description}{The description of the product.}

\item{Distributor}{The distributor of the product.}

\item{SupportDescription}{The support information about the product.}

\item{SupportEmail}{The contact email for product support.}

\item{SupportUrl}{The contact URL for product support.

\verb{^https?:\\/\\// }/ is the pattern used to validate SupportUrl.}

\item{ProductType}{[required] The type of product.}

\item{Tags}{One or more tags.}

\item{ProvisioningArtifactParameters}{The configuration of the provisioning artifact.}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}

\item{SourceConnection}{Specifies connection details for the created product and syncs the
product to the connection source artifact. This automatically manages
the product's artifacts based on changes to the source. The
\code{SourceConnection} parameter consists of the following sub-fields.
\itemize{
\item \code{Type}
\item \code{ConnectionParamters}
}}
}
\description{
Creates a product.

See \url{https://www.paws-r-sdk.com/docs/servicecatalog_create_product/} for full documentation.
}
\keyword{internal}
