% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_license_configurations}
\alias{licensemanager_list_license_configurations}
\title{Lists the license configurations for your account}
\usage{
licensemanager_list_license_configurations(
  LicenseConfigurationArns = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL
)
}
\arguments{
\item{LicenseConfigurationArns}{Amazon Resource Names (ARN) of the license configurations.}

\item{MaxResults}{Maximum number of results to return in a single call.}

\item{NextToken}{Token for the next set of results.}

\item{Filters}{Filters to scope the results. The following filters and logical
operators are supported:
\itemize{
\item \code{licenseCountingType} - The dimension for which licenses are
counted. Possible values are \code{vCPU} | \code{Instance} | \code{Core} |
\code{Socket}. Logical operators are \code{EQUALS} | \code{NOT_EQUALS}.
\item \code{enforceLicenseCount} - A Boolean value that indicates whether hard
license enforcement is used. Logical operators are \code{EQUALS} |
\code{NOT_EQUALS}.
\item \code{usagelimitExceeded} - A Boolean value that indicates whether the
available licenses have been exceeded. Logical operators are
\code{EQUALS} | \code{NOT_EQUALS}.
}}
}
\description{
Lists the license configurations for your account.

See \url{https://www.paws-r-sdk.com/docs/licensemanager_list_license_configurations/} for full documentation.
}
\keyword{internal}
