% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_get_kx_connection_string}
\alias{finspace_get_kx_connection_string}
\title{Retrieves a connection string for a user to connect to a kdb cluster}
\usage{
finspace_get_kx_connection_string(userArn, environmentId, clusterName)
}
\arguments{
\item{userArn}{[required] The Amazon Resource Name (ARN) that identifies the user. For more
information about ARNs and how to use ARNs in policies, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.}

\item{environmentId}{[required] A unique identifier for the kdb environment.}

\item{clusterName}{[required] A name of the kdb cluster.}
}
\description{
Retrieves a connection string for a user to connect to a kdb cluster. You must call this API using the same role that you have defined while creating a user.

See \url{https://www.paws-r-sdk.com/docs/finspace_get_kx_connection_string/} for full documentation.
}
\keyword{internal}
