% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchrum_operations.R
\name{cloudwatchrum_delete_rum_metrics_destination}
\alias{cloudwatchrum_delete_rum_metrics_destination}
\title{Deletes a destination for CloudWatch RUM extended metrics, so that the
specified app monitor stops sending extended metrics to that destination}
\usage{
cloudwatchrum_delete_rum_metrics_destination(
  AppMonitorName,
  Destination,
  DestinationArn = NULL
)
}
\arguments{
\item{AppMonitorName}{[required] The name of the app monitor that is sending metrics to the destination
that you want to delete.}

\item{Destination}{[required] The type of destination to delete. Valid values are \code{CloudWatch} and
\code{Evidently}.}

\item{DestinationArn}{This parameter is required if \code{Destination} is \code{Evidently}. If
\code{Destination} is \code{CloudWatch}, do not use this parameter. This parameter
specifies the ARN of the Evidently experiment that corresponds to the
destination to delete.}
}
\description{
Deletes a destination for CloudWatch RUM extended metrics, so that the specified app monitor stops sending extended metrics to that destination.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchrum_delete_rum_metrics_destination/} for full documentation.
}
\keyword{internal}
