% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevidently_operations.R
\name{cloudwatchevidently_get_experiment_results}
\alias{cloudwatchevidently_get_experiment_results}
\title{Retrieves the results of a running or completed experiment}
\usage{
cloudwatchevidently_get_experiment_results(
  baseStat = NULL,
  endTime = NULL,
  experiment,
  metricNames,
  period = NULL,
  project,
  reportNames = NULL,
  resultStats = NULL,
  startTime = NULL,
  treatmentNames
)
}
\arguments{
\item{baseStat}{The statistic used to calculate experiment results. Currently the only
valid value is \code{mean}, which uses the mean of the collected values as
the statistic.}

\item{endTime}{The date and time that the experiment ended, if it is completed. This
must be no longer than 30 days after the experiment start time.}

\item{experiment}{[required] The name of the experiment to retrieve the results of.}

\item{metricNames}{[required] The names of the experiment metrics that you want to see the results of.}

\item{period}{In seconds, the amount of time to aggregate results together.}

\item{project}{[required] The name or ARN of the project that contains the experiment that you
want to see the results of.}

\item{reportNames}{The names of the report types that you want to see. Currently,
\code{BayesianInference} is the only valid value.}

\item{resultStats}{The statistics that you want to see in the returned results.
\itemize{
\item \code{PValue} specifies to use p-values for the results. A p-value is
used in hypothesis testing to measure how often you are willing to
make a mistake in rejecting the null hypothesis. A general practice
is to reject the null hypothesis and declare that the results are
statistically significant when the p-value is less than 0.05.
\item \code{ConfidenceInterval} specifies a confidence interval for the
results. The confidence interval represents the range of values for
the chosen metric that is likely to contain the true difference
between the \code{baseStat} of a variation and the baseline. Evidently
returns the 95\% confidence interval.
\item \code{TreatmentEffect} is the difference in the statistic specified by
the \code{baseStat} parameter between each variation and the default
variation.
\item \code{BaseStat} returns the statistical values collected for the metric
for each variation. The statistic uses the same statistic specified
in the \code{baseStat} parameter. Therefore, if \code{baseStat} is \code{mean},
this returns the mean of the values collected for each variation.
}}

\item{startTime}{The date and time that the experiment started.}

\item{treatmentNames}{[required] The names of the experiment treatments that you want to see the results
for.}
}
\description{
Retrieves the results of a running or completed experiment. No results are available until there have been 100 events for each variation and at least 10 minutes have passed since the start of the experiment. To increase the statistical power, Evidently performs an additional offline p-value analysis at the end of the experiment. Offline p-value analysis can detect statistical significance in some cases where the anytime p-values used during the experiment do not find statistical significance.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchevidently_get_experiment_results/} for full documentation.
}
\keyword{internal}
