% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_describe_traffic_sources}
\alias{autoscaling_describe_traffic_sources}
\title{Gets information about the traffic sources for the specified Auto
Scaling group}
\usage{
autoscaling_describe_traffic_sources(
  AutoScalingGroupName,
  TrafficSourceType = NULL,
  NextToken = NULL,
  MaxRecords = NULL
)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{TrafficSourceType}{The traffic source type that you want to describe.

The following lists the valid values:
\itemize{
\item \code{elb} if the traffic source is a Classic Load Balancer.
\item \code{elbv2} if the traffic source is a Application Load Balancer,
Gateway Load Balancer, or Network Load Balancer.
\item \code{vpc-lattice} if the traffic source is VPC Lattice.
}}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxRecords}{The maximum number of items to return with this call. The maximum value
is \code{50}.}
}
\description{
Gets information about the traffic sources for the specified Auto Scaling group.

See \url{https://www.paws-r-sdk.com/docs/autoscaling_describe_traffic_sources/} for full documentation.
}
\keyword{internal}
