% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationautoscaling_operations.R
\name{applicationautoscaling_untag_resource}
\alias{applicationautoscaling_untag_resource}
\title{Deletes tags from an Application Auto Scaling scalable target}
\usage{
applicationautoscaling_untag_resource(ResourceARN, TagKeys)
}
\arguments{
\item{ResourceARN}{[required] Identifies the Application Auto Scaling scalable target from which to
remove tags.

For example:
\verb{arn:aws:application-autoscaling:us-east-1:123456789012:scalable-target/1234abcd56ab78cd901ef1234567890ab123}

To get the ARN for a scalable target, use
\code{\link[=applicationautoscaling_describe_scalable_targets]{describe_scalable_targets}}.}

\item{TagKeys}{[required] One or more tag keys. Specify only the tag keys, not the tag values.}
}
\description{
Deletes tags from an Application Auto Scaling scalable target. To delete a tag, specify the tag key and the Application Auto Scaling scalable target.

See \url{https://www.paws-r-sdk.com/docs/applicationautoscaling_untag_resource/} for full documentation.
}
\keyword{internal}
