% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmcontacts_operations.R
\name{ssmcontacts_create_contact_channel}
\alias{ssmcontacts_create_contact_channel}
\title{A contact channel is the method that Incident Manager uses to engage
your contact}
\usage{
ssmcontacts_create_contact_channel(
  ContactId,
  Name,
  Type,
  DeliveryAddress,
  DeferActivation = NULL,
  IdempotencyToken = NULL
)
}
\arguments{
\item{ContactId}{[required] The Amazon Resource Name (ARN) of the contact you are adding the contact
channel to.}

\item{Name}{[required] The name of the contact channel.}

\item{Type}{[required] Incident Manager supports three types of contact channels:
\itemize{
\item \code{SMS}
\item \code{VOICE}
\item \code{EMAIL}
}}

\item{DeliveryAddress}{[required] The details that Incident Manager uses when trying to engage the contact
channel. The format is dependent on the type of the contact channel. The
following are the expected formats:
\itemize{
\item SMS - '+' followed by the country code and phone number
\item VOICE - '+' followed by the country code and phone number
\item EMAIL - any standard email format
}}

\item{DeferActivation}{If you want to activate the channel at a later time, you can choose to
defer activation. Incident Manager can't engage your contact channel
until it has been activated.}

\item{IdempotencyToken}{A token ensuring that the operation is called only once with the
specified details.}
}
\description{
A contact channel is the method that Incident Manager uses to engage your contact.

See \url{https://paws-r.github.io/docs/ssmcontacts/create_contact_channel.html} for full documentation.
}
\keyword{internal}
