% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_list_app_version_resources}
\alias{resiliencehub_list_app_version_resources}
\title{Lists all the resources in an application version}
\usage{
resiliencehub_list_app_version_resources(
  appArn,
  appVersion,
  maxResults = NULL,
  nextToken = NULL,
  resolutionId = NULL
)
}
\arguments{
\item{appArn}{[required] The Amazon Resource Name (ARN) of the application. The format for this
ARN is: arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference}.}

\item{appVersion}{[required] The version of the application.}

\item{maxResults}{The maximum number of results to include in the response. If more
results exist than the specified \code{MaxResults} value, a token is included
in the response so that the remaining results can be retrieved.}

\item{nextToken}{Null, or the token from a previous call to get the next set of results.}

\item{resolutionId}{The identifier for a specific resolution.}
}
\description{
Lists all the resources in an application version.

See \url{https://paws-r.github.io/docs/resiliencehub/list_app_version_resources.html} for full documentation.
}
\keyword{internal}
