% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_resource_inventory}
\alias{licensemanager_list_resource_inventory}
\title{Lists resources managed using Systems Manager inventory}
\usage{
licensemanager_list_resource_inventory(
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL
)
}
\arguments{
\item{MaxResults}{Maximum number of results to return in a single call.}

\item{NextToken}{Token for the next set of results.}

\item{Filters}{Filters to scope the results. The following filters and logical
operators are supported:
\itemize{
\item \code{account_id} - The ID of the Amazon Web Services account that owns
the resource. Logical operators are \code{EQUALS} | \code{NOT_EQUALS}.
\item \code{application_name} - The name of the application. Logical operators
are \code{EQUALS} | \code{BEGINS_WITH}.
\item \code{license_included} - The type of license included. Logical operators
are \code{EQUALS} | \code{NOT_EQUALS}. Possible values are
\code{sql-server-enterprise} | \code{sql-server-standard} | \code{sql-server-web} |
\code{windows-server-datacenter}.
\item \code{platform} - The platform of the resource. Logical operators are
\code{EQUALS} | \code{BEGINS_WITH}.
\item \code{resource_id} - The ID of the resource. Logical operators are
\code{EQUALS} | \code{NOT_EQUALS}.
\item \verb{tag:<key>} - The key/value combination of a tag assigned to the
resource. Logical operators are \code{EQUALS} (single account) or
\code{EQUALS} | \code{NOT_EQUALS} (cross account).
}}
}
\description{
Lists resources managed using Systems Manager inventory.

See \url{https://paws-r.github.io/docs/licensemanager/list_resource_inventory.html} for full documentation.
}
\keyword{internal}
