% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_events_for_organization}
\alias{health_describe_events_for_organization}
\title{Returns information about events across your organization in
Organizations}
\usage{
health_describe_events_for_organization(
  filter = NULL,
  nextToken = NULL,
  maxResults = NULL,
  locale = NULL
)
}
\arguments{
\item{filter}{Values to narrow the results returned.}

\item{nextToken}{If the results of a search are large, only a portion of the results are
returned, and a \code{nextToken} pagination token is returned in the
response. To retrieve the next batch of results, reissue the search
request and include the returned token. When all results have been
returned, the response does not contain a pagination token value.}

\item{maxResults}{The maximum number of items to return in one batch, between 10 and 100,
inclusive.}

\item{locale}{The locale (language) to return information in. English (en) is the
default and the only supported value at this time.}
}
\description{
Returns information about events across your organization in Organizations. You can use the\code{filters} parameter to specify the events that you want to return. Events are returned in a summary form and don't include the affected accounts, detailed description, any additional metadata that depends on the event type, or any affected resources. To retrieve that information, use the following operations:

See \url{https://paws-r.github.io/docs/health/describe_events_for_organization.html} for full documentation.
}
\keyword{internal}
