% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_compliance_details_by_config_rule}
\alias{configservice_get_compliance_details_by_config_rule}
\title{Returns the evaluation results for the specified Config rule}
\usage{
configservice_get_compliance_details_by_config_rule(
  ConfigRuleName,
  ComplianceTypes = NULL,
  Limit = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ConfigRuleName}{[required] The name of the Config rule for which you want compliance information.}

\item{ComplianceTypes}{Filters the results by compliance.

The allowed values are \code{COMPLIANT}, \code{NON_COMPLIANT}, and
\code{NOT_APPLICABLE}.}

\item{Limit}{The maximum number of evaluation results returned on each page. The
default is 10. You cannot specify a number greater than 100. If you
specify 0, Config uses the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.

See \url{https://paws-r.github.io/docs/configservice/get_compliance_details_by_config_rule.html} for full documentation.
}
\keyword{internal}
