% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_get_log_events}
\alias{cloudwatchlogs_get_log_events}
\title{Lists log events from the specified log stream}
\usage{
cloudwatchlogs_get_log_events(
  logGroupName,
  logStreamName,
  startTime = NULL,
  endTime = NULL,
  nextToken = NULL,
  limit = NULL,
  startFromHead = NULL
)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{logStreamName}{[required] The name of the log stream.}

\item{startTime}{The start of the time range, expressed as the number of milliseconds
after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to this
time or later than this time are included. Events with a timestamp
earlier than this time are not included.}

\item{endTime}{The end of the time range, expressed as the number of milliseconds after
Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to or later than
this time are not included.}

\item{nextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{limit}{The maximum number of log events returned. If you don't specify a value,
the maximum is as many log events as can fit in a response size of 1 MB,
up to 10,000 log events.}

\item{startFromHead}{If the value is true, the earliest log events are returned first. If the
value is false, the latest log events are returned first. The default
value is false.

If you are using a previous \code{nextForwardToken} value as the \code{nextToken}
in this operation, you must specify \code{true} for \code{startFromHead}.}
}
\description{
Lists log events from the specified log stream. You can list all of the log events or filter using a time range.

See \url{https://paws-r.github.io/docs/cloudwatchlogs/get_log_events.html} for full documentation.
}
\keyword{internal}
