% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_types}
\alias{cloudformation_list_types}
\title{Returns summary information about extension that have been registered
with CloudFormation}
\usage{
cloudformation_list_types(
  Visibility = NULL,
  ProvisioningType = NULL,
  DeprecatedStatus = NULL,
  Type = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Visibility}{The scope at which the extensions are visible and usable in
CloudFormation operations.

Valid values include:
\itemize{
\item \code{PRIVATE}: Extensions that are visible and usable within this
account and region. This includes:
\itemize{
\item Private extensions you have registered in this account and
region.
\item Public extensions that you have activated in this account and
region.
}
\item \code{PUBLIC}: Extensions that are publicly visible and available to be
activated within any Amazon Web Services account. This includes
extensions from Amazon Web Services, in addition to third-party
publishers.
}

The default is \code{PRIVATE}.}

\item{ProvisioningType}{For resource types, the provisioning behavior of the resource type.
CloudFormation determines the provisioning type during registration,
based on the types of handlers in the schema handler package submitted.

Valid values include:
\itemize{
\item \code{FULLY_MUTABLE}: The resource type includes an update handler to
process updates to the type during stack update operations.
\item \code{IMMUTABLE}: The resource type doesn't include an update handler, so
the type can't be updated and must instead be replaced during stack
update operations.
\item \code{NON_PROVISIONABLE}: The resource type doesn't include create, read,
and delete handlers, and therefore can't actually be provisioned.
}

The default is \code{FULLY_MUTABLE}.}

\item{DeprecatedStatus}{The deprecation status of the extension that you want to get summary
information about.

Valid values include:
\itemize{
\item \code{LIVE}: The extension is registered for use in CloudFormation
operations.
\item \code{DEPRECATED}: The extension has been deregistered and can no longer
be used in CloudFormation operations.
}}

\item{Type}{The type of extension.}

\item{Filters}{Filter criteria to use in determining which extensions to return.

Filters must be compatible with \code{Visibility} to return valid results.
For example, specifying \code{AWS_TYPES} for \code{Category} and \code{PRIVATE} for
\code{Visibility} returns an empty list of types, but specifying \code{PUBLIC} for
\code{Visibility} returns the desired list.}

\item{MaxResults}{The maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.}

\item{NextToken}{If the previous paginated request didn't return all the remaining
results, the response object's \code{NextToken} parameter value is set to a
token. To retrieve the next set of results, call this action again and
assign that token to the request object's \code{NextToken} parameter. If
there are no remaining results, the previous response object's
\code{NextToken} parameter is set to \code{null}.}
}
\description{
Returns summary information about extension that have been registered with CloudFormation.

See \url{https://paws-r.github.io/docs/cloudformation/list_types.html} for full documentation.
}
\keyword{internal}
