# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include opsworkscm_service.R
NULL

#' Associates a new node with the server
#'
#' @description
#' Associates a new node with the server. For more information about how to disassociate a node, see [`disassociate_node`][opsworkscm_disassociate_node].
#'
#' See [https://paws-r.github.io/docs/opsworkscm/associate_node.html](https://paws-r.github.io/docs/opsworkscm/associate_node.html) for full documentation.
#'
#' @param ServerName &#91;required&#93; The name of the server with which to associate the node.
#' @param NodeName &#91;required&#93; The name of the node.
#' @param EngineAttributes &#91;required&#93; Engine attributes used for associating the node.
#' 
#' **Attributes accepted in a AssociateNode request for Chef**
#' 
#' -   `CHEF_ORGANIZATION`: The Chef organization with which the node is
#'     associated. By default only one organization named `default` can
#'     exist.
#' 
#' -   `CHEF_NODE_PUBLIC_KEY`: A PEM-formatted public key. This key is
#'     required for the `chef-client` agent to access the Chef API.
#' 
#' **Attributes accepted in a AssociateNode request for Puppet**
#' 
#' -   `PUPPET_NODE_CSR`: A PEM-formatted certificate-signing request (CSR)
#'     that is created by the node.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_associate_node
opsworkscm_associate_node <- function(ServerName, NodeName, EngineAttributes) {
  op <- new_operation(
    name = "AssociateNode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$associate_node_input(ServerName = ServerName, NodeName = NodeName, EngineAttributes = EngineAttributes)
  output <- .opsworkscm$associate_node_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$associate_node <- opsworkscm_associate_node

#' Creates an application-level backup of a server
#'
#' @description
#' Creates an application-level backup of a server. While the server is in the `BACKING_UP` state, the server cannot be changed, and no additional backup can be created.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/create_backup.html](https://paws-r.github.io/docs/opsworkscm/create_backup.html) for full documentation.
#'
#' @param ServerName &#91;required&#93; The name of the server that you want to back up.
#' @param Description A user-defined description of the backup.
#' @param Tags A map that contains tag keys and tag values to attach to an AWS
#' OpsWorks-CM server backup.
#' 
#' -   The key cannot be empty.
#' 
#' -   The key can be a maximum of 127 characters, and can contain only
#'     Unicode letters, numbers, or separators, or the following special
#'     characters: `+ - = . _ : /`
#' 
#' -   The value can be a maximum 255 characters, and contain only Unicode
#'     letters, numbers, or separators, or the following special
#'     characters: `+ - = . _ : /`
#' 
#' -   Leading and trailing white spaces are trimmed from both the key and
#'     value.
#' 
#' -   A maximum of 50 user-applied tags is allowed for tag-supported AWS
#'     OpsWorks-CM resources.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_create_backup
opsworkscm_create_backup <- function(ServerName, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$create_backup_input(ServerName = ServerName, Description = Description, Tags = Tags)
  output <- .opsworkscm$create_backup_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$create_backup <- opsworkscm_create_backup

#' Creates and immedately starts a new server
#'
#' @description
#' Creates and immedately starts a new server. The server is ready to use when it is in the `HEALTHY` state. By default, you can create a maximum of 10 servers.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/create_server.html](https://paws-r.github.io/docs/opsworkscm/create_server.html) for full documentation.
#'
#' @param AssociatePublicIpAddress Associate a public IP address with a server that you are launching.
#' Valid values are `true` or `false`. The default value is `true`.
#' @param CustomDomain An optional public endpoint of a server, such as
#' `https://aws.my-company.com`. To access the server, create a CNAME DNS
#' record in your preferred DNS service that points the custom domain to
#' the endpoint that is generated when the server is created (the value of
#' the CreateServer Endpoint attribute). You cannot access the server by
#' using the generated `Endpoint` value if the server is using a custom
#' domain. If you specify a custom domain, you must also specify values for
#' `CustomCertificate` and `CustomPrivateKey`.
#' @param CustomCertificate A PEM-formatted HTTPS certificate. The value can be be a single,
#' self-signed certificate, or a certificate chain. If you specify a custom
#' certificate, you must also specify values for `CustomDomain` and
#' `CustomPrivateKey`. The following are requirements for the
#' `CustomCertificate` value:
#' 
#' -   You can provide either a self-signed, custom certificate, or the
#'     full certificate chain.
#' 
#' -   The certificate must be a valid X509 certificate, or a certificate
#'     chain in PEM format.
#' 
#' -   The certificate must be valid at the time of upload. A certificate
#'     can't be used before its validity period begins (the certificate's
#'     `NotBefore` date), or after it expires (the certificate's `NotAfter`
#'     date).
#' 
#' -   The certificate’s common name or subject alternative names (SANs),
#'     if present, must match the value of `CustomDomain`.
#' 
#' -   The certificate must match the value of `CustomPrivateKey`.
#' @param CustomPrivateKey A private key in PEM format for connecting to the server by using HTTPS.
#' The private key must not be encrypted; it cannot be protected by a
#' password or passphrase. If you specify a custom private key, you must
#' also specify values for `CustomDomain` and `CustomCertificate`.
#' @param DisableAutomatedBackup Enable or disable scheduled backups. Valid values are `true` or `false`.
#' The default value is `true`.
#' @param Engine &#91;required&#93; The configuration management engine to use. Valid values include
#' `ChefAutomate` and `Puppet`.
#' @param EngineModel The engine model of the server. Valid values in this release include
#' `Monolithic` for Puppet and `Single` for Chef.
#' @param EngineVersion The major release version of the engine that you want to use. For a Chef
#' server, the valid value for EngineVersion is currently `2`. For a Puppet
#' server, valid values are `2019` or `2017`.
#' @param EngineAttributes Optional engine attributes on a specified server.
#' 
#' **Attributes accepted in a Chef createServer request:**
#' 
#' -   `CHEF_AUTOMATE_PIVOTAL_KEY`: A base64-encoded RSA public key. The
#'     corresponding private key is required to access the Chef API. When
#'     no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and
#'     returned in the response.
#' 
#' -   `CHEF_AUTOMATE_ADMIN_PASSWORD`: The password for the administrative
#'     user in the Chef Automate web-based dashboard. The password length
#'     is a minimum of eight characters, and a maximum of 32. The password
#'     can contain letters, numbers, and special characters (!/@@#$%^&+=_).
#'     The password must contain at least one lower case letter, one upper
#'     case letter, one number, and one special character. When no
#'     CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned
#'     in the response.
#' 
#' **Attributes accepted in a Puppet createServer request:**
#' 
#' -   `PUPPET_ADMIN_PASSWORD`: To work with the Puppet Enterprise console,
#'     a password must use ASCII characters.
#' 
#' -   `PUPPET_R10K_REMOTE`: The r10k remote is the URL of your control
#'     repository (for example,
#'     ssh://git@@your.git-repo.com:user/control-repo.git). Specifying an
#'     r10k remote opens TCP port 8170.
#' 
#' -   `PUPPET_R10K_PRIVATE_KEY`: If you are using a private Git
#'     repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded
#'     private SSH key.
#' @param BackupRetentionCount The number of automated backups that you want to keep. Whenever a new
#' backup is created, AWS OpsWorks CM deletes the oldest backups if this
#' number is exceeded. The default value is `1`.
#' @param ServerName &#91;required&#93; The name of the server. The server name must be unique within your AWS
#' account, within each region. Server names must start with a letter; then
#' letters, numbers, or hyphens (-) are allowed, up to a maximum of 40
#' characters.
#' @param InstanceProfileArn &#91;required&#93; The ARN of the instance profile that your Amazon EC2 instances use.
#' Although the AWS OpsWorks console typically creates the instance profile
#' for you, if you are using API commands instead, run the
#' service-role-creation.yaml AWS CloudFormation template, located at
#' https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml.
#' This template creates a CloudFormation stack that includes the instance
#' profile you need.
#' @param InstanceType &#91;required&#93; The Amazon EC2 instance type to use. For example, `m5.large`.
#' @param KeyPair The Amazon EC2 key pair to set for the instance. This parameter is
#' optional; if desired, you may specify this parameter to connect to your
#' instances by using SSH.
#' @param PreferredMaintenanceWindow The start time for a one-hour period each week during which AWS OpsWorks
#' CM performs maintenance on the instance. Valid values must be specified
#' in the following format: `DDD:HH:MM`. `MM` must be specified as `00`.
#' The specified time is in coordinated universal time (UTC). The default
#' value is a random one-hour period on Tuesday, Wednesday, or Friday. See
#' `TimeWindowDefinition` for more information.
#' 
#' **Example:** `Mon:08:00`, which represents a start time of every Monday
#' at 08:00 UTC. (8:00 a.m.)
#' @param PreferredBackupWindow The start time for a one-hour period during which AWS OpsWorks CM backs
#' up application-level data on your server if automated backups are
#' enabled. Valid values must be specified in one of the following formats:
#' 
#' -   `HH:MM` for daily backups
#' 
#' -   `DDD:HH:MM` for weekly backups
#' 
#' `MM` must be specified as `00`. The specified time is in coordinated
#' universal time (UTC). The default value is a random, daily start time.
#' 
#' **Example:** `08:00`, which represents a daily start time of 08:00 UTC.
#' 
#' **Example:** `Mon:08:00`, which represents a start time of every Monday
#' at 08:00 UTC. (8:00 a.m.)
#' @param SecurityGroupIds A list of security group IDs to attach to the Amazon EC2 instance. If
#' you add this parameter, the specified security groups must be within the
#' VPC that is specified by `SubnetIds`.
#' 
#' If you do not specify this parameter, AWS OpsWorks CM creates one new
#' security group that uses TCP ports 22 and 443, open to 0.0.0.0/0
#' (everyone).
#' @param ServiceRoleArn &#91;required&#93; The service role that the AWS OpsWorks CM service backend uses to work
#' with your account. Although the AWS OpsWorks management console
#' typically creates the service role for you, if you are using the AWS CLI
#' or API commands, run the service-role-creation.yaml AWS CloudFormation
#' template, located at
#' https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml.
#' This template creates a CloudFormation stack that includes the service
#' role and instance profile that you need.
#' @param SubnetIds The IDs of subnets in which to launch the server EC2 instance.
#' 
#' Amazon EC2-Classic customers: This field is required. All servers must
#' run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
#' 
#' EC2-VPC customers: This field is optional. If you do not specify subnet
#' IDs, your EC2 instances are created in a default subnet that is selected
#' by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign
#' Public IP" enabled.
#' 
#' For more information about supported Amazon EC2 platforms, see
#' [Supported
#' Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-classic-platform.html).
#' @param Tags A map that contains tag keys and tag values to attach to an AWS OpsWorks
#' for Chef Automate or AWS OpsWorks for Puppet Enterprise server.
#' 
#' -   The key cannot be empty.
#' 
#' -   The key can be a maximum of 127 characters, and can contain only
#'     Unicode letters, numbers, or separators, or the following special
#'     characters: `+ - = . _ : / @@`
#' 
#' -   The value can be a maximum 255 characters, and contain only Unicode
#'     letters, numbers, or separators, or the following special
#'     characters: `+ - = . _ : / @@`
#' 
#' -   Leading and trailing white spaces are trimmed from both the key and
#'     value.
#' 
#' -   A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM
#'     server.
#' @param BackupId If you specify this field, AWS OpsWorks CM creates the server by using
#' the backup represented by BackupId.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_create_server
opsworkscm_create_server <- function(AssociatePublicIpAddress = NULL, CustomDomain = NULL, CustomCertificate = NULL, CustomPrivateKey = NULL, DisableAutomatedBackup = NULL, Engine, EngineModel = NULL, EngineVersion = NULL, EngineAttributes = NULL, BackupRetentionCount = NULL, ServerName, InstanceProfileArn, InstanceType, KeyPair = NULL, PreferredMaintenanceWindow = NULL, PreferredBackupWindow = NULL, SecurityGroupIds = NULL, ServiceRoleArn, SubnetIds = NULL, Tags = NULL, BackupId = NULL) {
  op <- new_operation(
    name = "CreateServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$create_server_input(AssociatePublicIpAddress = AssociatePublicIpAddress, CustomDomain = CustomDomain, CustomCertificate = CustomCertificate, CustomPrivateKey = CustomPrivateKey, DisableAutomatedBackup = DisableAutomatedBackup, Engine = Engine, EngineModel = EngineModel, EngineVersion = EngineVersion, EngineAttributes = EngineAttributes, BackupRetentionCount = BackupRetentionCount, ServerName = ServerName, InstanceProfileArn = InstanceProfileArn, InstanceType = InstanceType, KeyPair = KeyPair, PreferredMaintenanceWindow = PreferredMaintenanceWindow, PreferredBackupWindow = PreferredBackupWindow, SecurityGroupIds = SecurityGroupIds, ServiceRoleArn = ServiceRoleArn, SubnetIds = SubnetIds, Tags = Tags, BackupId = BackupId)
  output <- .opsworkscm$create_server_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$create_server <- opsworkscm_create_server

#' Deletes a backup
#'
#' @description
#' Deletes a backup. You can delete both manual and automated backups. This operation is asynchronous.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/delete_backup.html](https://paws-r.github.io/docs/opsworkscm/delete_backup.html) for full documentation.
#'
#' @param BackupId &#91;required&#93; The ID of the backup to delete. Run the DescribeBackups command to get a
#' list of backup IDs. Backup IDs are in the format
#' `ServerName-yyyyMMddHHmmssSSS`.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_delete_backup
opsworkscm_delete_backup <- function(BackupId) {
  op <- new_operation(
    name = "DeleteBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$delete_backup_input(BackupId = BackupId)
  output <- .opsworkscm$delete_backup_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$delete_backup <- opsworkscm_delete_backup

#' Deletes the server and the underlying AWS CloudFormation stacks
#' (including the server's EC2 instance)
#'
#' @description
#' Deletes the server and the underlying AWS CloudFormation stacks (including the server's EC2 instance). When you run this command, the server state is updated to `DELETING`. After the server is deleted, it is no longer returned by `DescribeServer` requests. If the AWS CloudFormation stack cannot be deleted, the server cannot be deleted.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/delete_server.html](https://paws-r.github.io/docs/opsworkscm/delete_server.html) for full documentation.
#'
#' @param ServerName &#91;required&#93; The ID of the server to delete.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_delete_server
opsworkscm_delete_server <- function(ServerName) {
  op <- new_operation(
    name = "DeleteServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$delete_server_input(ServerName = ServerName)
  output <- .opsworkscm$delete_server_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$delete_server <- opsworkscm_delete_server

#' Describes your OpsWorks-CM account attributes
#'
#' @description
#' Describes your OpsWorks-CM account attributes.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/describe_account_attributes.html](https://paws-r.github.io/docs/opsworkscm/describe_account_attributes.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_describe_account_attributes
opsworkscm_describe_account_attributes <- function() {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$describe_account_attributes_input()
  output <- .opsworkscm$describe_account_attributes_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$describe_account_attributes <- opsworkscm_describe_account_attributes

#' Describes backups
#'
#' @description
#' Describes backups. The results are ordered by time, with newest backups first. If you do not specify a BackupId or ServerName, the command returns all backups.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/describe_backups.html](https://paws-r.github.io/docs/opsworkscm/describe_backups.html) for full documentation.
#'
#' @param BackupId Describes a single backup.
#' @param ServerName Returns backups for the server with the specified ServerName.
#' @param NextToken This is not currently implemented for
#' [`describe_backups`][opsworkscm_describe_backups] requests.
#' @param MaxResults This is not currently implemented for
#' [`describe_backups`][opsworkscm_describe_backups] requests.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_describe_backups
opsworkscm_describe_backups <- function(BackupId = NULL, ServerName = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$describe_backups_input(BackupId = BackupId, ServerName = ServerName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .opsworkscm$describe_backups_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$describe_backups <- opsworkscm_describe_backups

#' Describes events for a specified server
#'
#' @description
#' Describes events for a specified server. Results are ordered by time, with newest events first.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/describe_events.html](https://paws-r.github.io/docs/opsworkscm/describe_events.html) for full documentation.
#'
#' @param ServerName &#91;required&#93; The name of the server for which you want to view events.
#' @param NextToken NextToken is a string that is returned in some command responses. It
#' indicates that not all entries have been returned, and that you must run
#' at least one more request to get remaining items. To get remaining
#' results, call [`describe_events`][opsworkscm_describe_events] again, and
#' assign the token from the previous results as the value of the
#' `nextToken` parameter. If there are no more results, the response
#' object's `nextToken` parameter value is `null`. Setting a `nextToken`
#' value that was not returned in your previous results causes an
#' `InvalidNextTokenException` to occur.
#' @param MaxResults To receive a paginated response, use this parameter to specify the
#' maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_describe_events
opsworkscm_describe_events <- function(ServerName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$describe_events_input(ServerName = ServerName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .opsworkscm$describe_events_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$describe_events <- opsworkscm_describe_events

#' Returns the current status of an existing association or disassociation
#' request
#'
#' @description
#' Returns the current status of an existing association or disassociation request.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/describe_node_association_status.html](https://paws-r.github.io/docs/opsworkscm/describe_node_association_status.html) for full documentation.
#'
#' @param NodeAssociationStatusToken &#91;required&#93; The token returned in either the AssociateNodeResponse or the
#' DisassociateNodeResponse.
#' @param ServerName &#91;required&#93; The name of the server from which to disassociate the node.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_describe_node_association_status
opsworkscm_describe_node_association_status <- function(NodeAssociationStatusToken, ServerName) {
  op <- new_operation(
    name = "DescribeNodeAssociationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$describe_node_association_status_input(NodeAssociationStatusToken = NodeAssociationStatusToken, ServerName = ServerName)
  output <- .opsworkscm$describe_node_association_status_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$describe_node_association_status <- opsworkscm_describe_node_association_status

#' Lists all configuration management servers that are identified with your
#' account
#'
#' @description
#' Lists all configuration management servers that are identified with your account. Only the stored results from Amazon DynamoDB are returned. AWS OpsWorks CM does not query other services.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/describe_servers.html](https://paws-r.github.io/docs/opsworkscm/describe_servers.html) for full documentation.
#'
#' @param ServerName Describes the server with the specified ServerName.
#' @param NextToken This is not currently implemented for
#' [`describe_servers`][opsworkscm_describe_servers] requests.
#' @param MaxResults This is not currently implemented for
#' [`describe_servers`][opsworkscm_describe_servers] requests.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_describe_servers
opsworkscm_describe_servers <- function(ServerName = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeServers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$describe_servers_input(ServerName = ServerName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .opsworkscm$describe_servers_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$describe_servers <- opsworkscm_describe_servers

#' Disassociates a node from an AWS OpsWorks CM server, and removes the
#' node from the server's managed nodes
#'
#' @description
#' Disassociates a node from an AWS OpsWorks CM server, and removes the node from the server's managed nodes. After a node is disassociated, the node key pair is no longer valid for accessing the configuration manager's API. For more information about how to associate a node, see [`associate_node`][opsworkscm_associate_node].
#'
#' See [https://paws-r.github.io/docs/opsworkscm/disassociate_node.html](https://paws-r.github.io/docs/opsworkscm/disassociate_node.html) for full documentation.
#'
#' @param ServerName &#91;required&#93; The name of the server from which to disassociate the node.
#' @param NodeName &#91;required&#93; The name of the client node.
#' @param EngineAttributes Engine attributes that are used for disassociating the node. No
#' attributes are required for Puppet.
#' 
#' **Attributes required in a DisassociateNode request for Chef**
#' 
#' -   `CHEF_ORGANIZATION`: The Chef organization with which the node was
#'     associated. By default only one organization named `default` can
#'     exist.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_disassociate_node
opsworkscm_disassociate_node <- function(ServerName, NodeName, EngineAttributes = NULL) {
  op <- new_operation(
    name = "DisassociateNode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$disassociate_node_input(ServerName = ServerName, NodeName = NodeName, EngineAttributes = EngineAttributes)
  output <- .opsworkscm$disassociate_node_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$disassociate_node <- opsworkscm_disassociate_node

#' Exports a specified server engine attribute as a base64-encoded string
#'
#' @description
#' Exports a specified server engine attribute as a base64-encoded string. For example, you can export user data that you can use in EC2 to associate nodes with a server.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/export_server_engine_attribute.html](https://paws-r.github.io/docs/opsworkscm/export_server_engine_attribute.html) for full documentation.
#'
#' @param ExportAttributeName &#91;required&#93; The name of the export attribute. Currently, the supported export
#' attribute is `Userdata`. This exports a user data script that includes
#' parameters and values provided in the `InputAttributes` list.
#' @param ServerName &#91;required&#93; The name of the server from which you are exporting the attribute.
#' @param InputAttributes The list of engine attributes. The list type is `EngineAttribute`. An
#' `EngineAttribute` list item is a pair that includes an attribute name
#' and its value. For the `Userdata` ExportAttributeName, the following are
#' supported engine attribute names.
#' 
#' -   **RunList** In Chef, a list of roles or recipes that are run in the
#'     specified order. In Puppet, this parameter is ignored.
#' 
#' -   **OrganizationName** In Chef, an organization name. AWS OpsWorks for
#'     Chef Automate always creates the organization `default`. In Puppet,
#'     this parameter is ignored.
#' 
#' -   **NodeEnvironment** In Chef, a node environment (for example,
#'     development, staging, or one-box). In Puppet, this parameter is
#'     ignored.
#' 
#' -   **NodeClientVersion** In Chef, the version of the Chef engine (three
#'     numbers separated by dots, such as 13.8.5). If this attribute is
#'     empty, OpsWorks for Chef Automate uses the most current version. In
#'     Puppet, this parameter is ignored.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_export_server_engine_attribute
opsworkscm_export_server_engine_attribute <- function(ExportAttributeName, ServerName, InputAttributes = NULL) {
  op <- new_operation(
    name = "ExportServerEngineAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$export_server_engine_attribute_input(ExportAttributeName = ExportAttributeName, ServerName = ServerName, InputAttributes = InputAttributes)
  output <- .opsworkscm$export_server_engine_attribute_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$export_server_engine_attribute <- opsworkscm_export_server_engine_attribute

#' Returns a list of tags that are applied to the specified AWS OpsWorks
#' for Chef Automate or AWS OpsWorks for Puppet Enterprise servers or
#' backups
#'
#' @description
#' Returns a list of tags that are applied to the specified AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise servers or backups.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/list_tags_for_resource.html](https://paws-r.github.io/docs/opsworkscm/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Number (ARN) of an AWS OpsWorks for Chef Automate or
#' AWS OpsWorks for Puppet Enterprise server for which you want to show
#' applied tags. For example,
#' `arn:aws:opsworks-cm:us-west-2:123456789012:server/test-owcm-server/EXAMPLE-66b0-4196-8274-d1a2bEXAMPLE`.
#' @param NextToken NextToken is a string that is returned in some command responses. It
#' indicates that not all entries have been returned, and that you must run
#' at least one more request to get remaining items. To get remaining
#' results, call
#' [`list_tags_for_resource`][opsworkscm_list_tags_for_resource] again, and
#' assign the token from the previous results as the value of the
#' `nextToken` parameter. If there are no more results, the response
#' object's `nextToken` parameter value is `null`. Setting a `nextToken`
#' value that was not returned in your previous results causes an
#' `InvalidNextTokenException` to occur.
#' @param MaxResults To receive a paginated response, use this parameter to specify the
#' maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_list_tags_for_resource
opsworkscm_list_tags_for_resource <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$list_tags_for_resource_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .opsworkscm$list_tags_for_resource_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$list_tags_for_resource <- opsworkscm_list_tags_for_resource

#' Restores a backup to a server that is in a CONNECTION_LOST, HEALTHY,
#' RUNNING, UNHEALTHY, or TERMINATED state
#'
#' @description
#' Restores a backup to a server that is in a `CONNECTION_LOST`, `HEALTHY`, `RUNNING`, `UNHEALTHY`, or `TERMINATED` state. When you run RestoreServer, the server's EC2 instance is deleted, and a new EC2 instance is configured. RestoreServer maintains the existing server endpoint, so configuration management of the server's client devices (nodes) should continue to work.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/restore_server.html](https://paws-r.github.io/docs/opsworkscm/restore_server.html) for full documentation.
#'
#' @param BackupId &#91;required&#93; The ID of the backup that you want to use to restore a server.
#' @param ServerName &#91;required&#93; The name of the server that you want to restore.
#' @param InstanceType The type of instance to restore. Valid values must be specified in the
#' following format: `^([cm][34]|t2).*` For example, `m5.large`. Valid
#' values are `m5.large`, `r5.xlarge`, and `r5.2xlarge`. If you do not
#' specify this parameter, RestoreServer uses the instance type from the
#' specified backup.
#' @param KeyPair The name of the key pair to set on the new EC2 instance. This can be
#' helpful if the administrator no longer has the SSH key.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_restore_server
opsworkscm_restore_server <- function(BackupId, ServerName, InstanceType = NULL, KeyPair = NULL) {
  op <- new_operation(
    name = "RestoreServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$restore_server_input(BackupId = BackupId, ServerName = ServerName, InstanceType = InstanceType, KeyPair = KeyPair)
  output <- .opsworkscm$restore_server_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$restore_server <- opsworkscm_restore_server

#' Manually starts server maintenance
#'
#' @description
#' Manually starts server maintenance. This command can be useful if an earlier maintenance attempt failed, and the underlying cause of maintenance failure has been resolved. The server is in an `UNDER_MAINTENANCE` state while maintenance is in progress.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/start_maintenance.html](https://paws-r.github.io/docs/opsworkscm/start_maintenance.html) for full documentation.
#'
#' @param ServerName &#91;required&#93; The name of the server on which to run maintenance.
#' @param EngineAttributes Engine attributes that are specific to the server on which you want to
#' run maintenance.
#' 
#' **Attributes accepted in a StartMaintenance request for Chef**
#' 
#' -   `CHEF_MAJOR_UPGRADE`: If a Chef Automate server is eligible for
#'     upgrade to Chef Automate 2, add this engine attribute to a
#'     [`start_maintenance`][opsworkscm_start_maintenance] request and set
#'     the value to `true` to upgrade the server to Chef Automate 2. For
#'     more information, see [Upgrade an AWS OpsWorks for Chef Automate
#'     Server to Chef Automate
#'     2](https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-a2upgrade.html).
#'
#' @keywords internal
#'
#' @rdname opsworkscm_start_maintenance
opsworkscm_start_maintenance <- function(ServerName, EngineAttributes = NULL) {
  op <- new_operation(
    name = "StartMaintenance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$start_maintenance_input(ServerName = ServerName, EngineAttributes = EngineAttributes)
  output <- .opsworkscm$start_maintenance_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$start_maintenance <- opsworkscm_start_maintenance

#' Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for
#' Puppet Enterprise server, or to server backups
#'
#' @description
#' Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server, or to server backups.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/tag_resource.html](https://paws-r.github.io/docs/opsworkscm/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Number (ARN) of a resource to which you want to
#' apply tags. For example,
#' `arn:aws:opsworks-cm:us-west-2:123456789012:server/test-owcm-server/EXAMPLE-66b0-4196-8274-d1a2bEXAMPLE`.
#' @param Tags &#91;required&#93; A map that contains tag keys and tag values to attach to AWS OpsWorks-CM
#' servers or backups.
#' 
#' -   The key cannot be empty.
#' 
#' -   The key can be a maximum of 127 characters, and can contain only
#'     Unicode letters, numbers, or separators, or the following special
#'     characters: `+ - = . _ : /`
#' 
#' -   The value can be a maximum 255 characters, and contain only Unicode
#'     letters, numbers, or separators, or the following special
#'     characters: `+ - = . _ : /`
#' 
#' -   Leading and trailing white spaces are trimmed from both the key and
#'     value.
#' 
#' -   A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM
#'     server or backup.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_tag_resource
opsworkscm_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .opsworkscm$tag_resource_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$tag_resource <- opsworkscm_tag_resource

#' Removes specified tags from an AWS OpsWorks-CM server or backup
#'
#' @description
#' Removes specified tags from an AWS OpsWorks-CM server or backup.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/untag_resource.html](https://paws-r.github.io/docs/opsworkscm/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Number (ARN) of a resource from which you want to
#' remove tags. For example,
#' `arn:aws:opsworks-cm:us-west-2:123456789012:server/test-owcm-server/EXAMPLE-66b0-4196-8274-d1a2bEXAMPLE`.
#' @param TagKeys &#91;required&#93; The keys of tags that you want to remove.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_untag_resource
opsworkscm_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .opsworkscm$untag_resource_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$untag_resource <- opsworkscm_untag_resource

#' Updates settings for a server
#'
#' @description
#' Updates settings for a server.
#'
#' See [https://paws-r.github.io/docs/opsworkscm/update_server.html](https://paws-r.github.io/docs/opsworkscm/update_server.html) for full documentation.
#'
#' @param DisableAutomatedBackup Setting DisableAutomatedBackup to `true` disables automated or scheduled
#' backups. Automated backups are enabled by default.
#' @param BackupRetentionCount Sets the number of automated backups that you want to keep.
#' @param ServerName &#91;required&#93; The name of the server to update.
#' @param PreferredMaintenanceWindow 
#' @param PreferredBackupWindow 
#'
#' @keywords internal
#'
#' @rdname opsworkscm_update_server
opsworkscm_update_server <- function(DisableAutomatedBackup = NULL, BackupRetentionCount = NULL, ServerName, PreferredMaintenanceWindow = NULL, PreferredBackupWindow = NULL) {
  op <- new_operation(
    name = "UpdateServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$update_server_input(DisableAutomatedBackup = DisableAutomatedBackup, BackupRetentionCount = BackupRetentionCount, ServerName = ServerName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, PreferredBackupWindow = PreferredBackupWindow)
  output <- .opsworkscm$update_server_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$update_server <- opsworkscm_update_server

#' Updates engine-specific attributes on a specified server
#'
#' @description
#' Updates engine-specific attributes on a specified server. The server enters the `MODIFYING` state when this operation is in progress. Only one update can occur at a time. You can use this command to reset a Chef server's public key (`CHEF_PIVOTAL_KEY`) or a Puppet server's admin password (`PUPPET_ADMIN_PASSWORD`).
#'
#' See [https://paws-r.github.io/docs/opsworkscm/update_server_engine_attributes.html](https://paws-r.github.io/docs/opsworkscm/update_server_engine_attributes.html) for full documentation.
#'
#' @param ServerName &#91;required&#93; The name of the server to update.
#' @param AttributeName &#91;required&#93; The name of the engine attribute to update.
#' @param AttributeValue The value to set for the attribute.
#'
#' @keywords internal
#'
#' @rdname opsworkscm_update_server_engine_attributes
opsworkscm_update_server_engine_attributes <- function(ServerName, AttributeName, AttributeValue = NULL) {
  op <- new_operation(
    name = "UpdateServerEngineAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworkscm$update_server_engine_attributes_input(ServerName = ServerName, AttributeName = AttributeName, AttributeValue = AttributeValue)
  output <- .opsworkscm$update_server_engine_attributes_output()
  config <- get_config()
  svc <- .opsworkscm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworkscm$operations$update_server_engine_attributes <- opsworkscm_update_server_engine_attributes
