# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include finspace_service.R
NULL

#' Create a new FinSpace environment
#'
#' @description
#' Create a new FinSpace environment.
#'
#' See [https://paws-r.github.io/docs/finspace/create_environment.html](https://paws-r.github.io/docs/finspace/create_environment.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the FinSpace environment to be created.
#' @param description The description of the FinSpace environment to be created.
#' @param kmsKeyId The KMS key id to encrypt your data in the FinSpace environment.
#' @param tags Add tags to your FinSpace environment.
#' @param federationMode Authentication mode for the environment.
#' 
#' -   `FEDERATED` - Users access FinSpace through Single Sign On (SSO) via
#'     your Identity provider.
#' 
#' -   `LOCAL` - Users access FinSpace via email and password managed
#'     within the FinSpace environment.
#' @param federationParameters Configuration information when authentication mode is FEDERATED.
#' @param superuserParameters Configuration information for the superuser.
#' @param dataBundles The list of Amazon Resource Names (ARN) of the data bundles to install.
#' Currently supported data bundle ARNs:
#' 
#' -   `arn:aws:finspace:${Region}::data-bundle/capital-markets-sample` -
#'     Contains sample Capital Markets datasets, categories and controlled
#'     vocabularies.
#' 
#' -   `arn:aws:finspace:${Region}::data-bundle/taq` (default) - Contains
#'     trades and quotes data in addition to sample Capital Markets data.
#'
#' @keywords internal
#'
#' @rdname finspace_create_environment
finspace_create_environment <- function(name, description = NULL, kmsKeyId = NULL, tags = NULL, federationMode = NULL, federationParameters = NULL, superuserParameters = NULL, dataBundles = NULL) {
  op <- new_operation(
    name = "CreateEnvironment",
    http_method = "POST",
    http_path = "/environment",
    paginator = list()
  )
  input <- .finspace$create_environment_input(name = name, description = description, kmsKeyId = kmsKeyId, tags = tags, federationMode = federationMode, federationParameters = federationParameters, superuserParameters = superuserParameters, dataBundles = dataBundles)
  output <- .finspace$create_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$create_environment <- finspace_create_environment

#' Delete an FinSpace environment
#'
#' @description
#' Delete an FinSpace environment.
#'
#' See [https://paws-r.github.io/docs/finspace/delete_environment.html](https://paws-r.github.io/docs/finspace/delete_environment.html) for full documentation.
#'
#' @param environmentId &#91;required&#93; The identifier for the FinSpace environment.
#'
#' @keywords internal
#'
#' @rdname finspace_delete_environment
finspace_delete_environment <- function(environmentId) {
  op <- new_operation(
    name = "DeleteEnvironment",
    http_method = "DELETE",
    http_path = "/environment/{environmentId}",
    paginator = list()
  )
  input <- .finspace$delete_environment_input(environmentId = environmentId)
  output <- .finspace$delete_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$delete_environment <- finspace_delete_environment

#' Returns the FinSpace environment object
#'
#' @description
#' Returns the FinSpace environment object.
#'
#' See [https://paws-r.github.io/docs/finspace/get_environment.html](https://paws-r.github.io/docs/finspace/get_environment.html) for full documentation.
#'
#' @param environmentId &#91;required&#93; The identifier of the FinSpace environment.
#'
#' @keywords internal
#'
#' @rdname finspace_get_environment
finspace_get_environment <- function(environmentId) {
  op <- new_operation(
    name = "GetEnvironment",
    http_method = "GET",
    http_path = "/environment/{environmentId}",
    paginator = list()
  )
  input <- .finspace$get_environment_input(environmentId = environmentId)
  output <- .finspace$get_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$get_environment <- finspace_get_environment

#' A list of all of your FinSpace environments
#'
#' @description
#' A list of all of your FinSpace environments.
#'
#' See [https://paws-r.github.io/docs/finspace/list_environments.html](https://paws-r.github.io/docs/finspace/list_environments.html) for full documentation.
#'
#' @param nextToken A token generated by FinSpace that specifies where to continue
#' pagination if a previous request was truncated. To get the next set of
#' pages, pass in the nextToken value from the response object of the
#' previous page call.
#' @param maxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname finspace_list_environments
finspace_list_environments <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEnvironments",
    http_method = "GET",
    http_path = "/environment",
    paginator = list()
  )
  input <- .finspace$list_environments_input(nextToken = nextToken, maxResults = maxResults)
  output <- .finspace$list_environments_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_environments <- finspace_list_environments

#' A list of all tags for a resource
#'
#' @description
#' A list of all tags for a resource.
#'
#' See [https://paws-r.github.io/docs/finspace/list_tags_for_resource.html](https://paws-r.github.io/docs/finspace/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name of the resource.
#'
#' @keywords internal
#'
#' @rdname finspace_list_tags_for_resource
finspace_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .finspace$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .finspace$list_tags_for_resource_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$list_tags_for_resource <- finspace_list_tags_for_resource

#' Adds metadata tags to a FinSpace resource
#'
#' @description
#' Adds metadata tags to a FinSpace resource.
#'
#' See [https://paws-r.github.io/docs/finspace/tag_resource.html](https://paws-r.github.io/docs/finspace/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource.
#' @param tags &#91;required&#93; One or more tags to be assigned to the resource.
#'
#' @keywords internal
#'
#' @rdname finspace_tag_resource
finspace_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .finspace$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .finspace$tag_resource_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$tag_resource <- finspace_tag_resource

#' Removes metadata tags from a FinSpace resource
#'
#' @description
#' Removes metadata tags from a FinSpace resource.
#'
#' See [https://paws-r.github.io/docs/finspace/untag_resource.html](https://paws-r.github.io/docs/finspace/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; A FinSpace resource from which you want to remove a tag or tags. The
#' value for this parameter is an Amazon Resource Name (ARN).
#' @param tagKeys &#91;required&#93; The tag keys (names) of one or more tags to be removed.
#'
#' @keywords internal
#'
#' @rdname finspace_untag_resource
finspace_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .finspace$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .finspace$untag_resource_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$untag_resource <- finspace_untag_resource

#' Update your FinSpace environment
#'
#' @description
#' Update your FinSpace environment.
#'
#' See [https://paws-r.github.io/docs/finspace/update_environment.html](https://paws-r.github.io/docs/finspace/update_environment.html) for full documentation.
#'
#' @param environmentId &#91;required&#93; The identifier of the FinSpace environment.
#' @param name The name of the environment.
#' @param description The description of the environment.
#' @param federationMode Authentication mode for the environment.
#' 
#' -   `FEDERATED` - Users access FinSpace through Single Sign On (SSO) via
#'     your Identity provider.
#' 
#' -   `LOCAL` - Users access FinSpace via email and password managed
#'     within the FinSpace environment.
#' @param federationParameters 
#'
#' @keywords internal
#'
#' @rdname finspace_update_environment
finspace_update_environment <- function(environmentId, name = NULL, description = NULL, federationMode = NULL, federationParameters = NULL) {
  op <- new_operation(
    name = "UpdateEnvironment",
    http_method = "PUT",
    http_path = "/environment/{environmentId}",
    paginator = list()
  )
  input <- .finspace$update_environment_input(environmentId = environmentId, name = name, description = description, federationMode = federationMode, federationParameters = federationParameters)
  output <- .finspace$update_environment_output()
  config <- get_config()
  svc <- .finspace$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspace$operations$update_environment <- finspace_update_environment
