% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_update_product}
\alias{servicecatalog_update_product}
\title{Updates the specified product}
\usage{
servicecatalog_update_product(AcceptLanguage, Id, Name, Owner,
  Description, Distributor, SupportDescription, SupportEmail, SupportUrl,
  AddTags, RemoveTags)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{Id}{[required] The product identifier.}

\item{Name}{The updated product name.}

\item{Owner}{The updated owner of the product.}

\item{Description}{The updated description of the product.}

\item{Distributor}{The updated distributor of the product.}

\item{SupportDescription}{The updated support description for the product.}

\item{SupportEmail}{The updated support email for the product.}

\item{SupportUrl}{The updated support URL for the product.}

\item{AddTags}{The tags to add to the product.}

\item{RemoveTags}{The tags to remove from the product.}
}
\description{
Updates the specified product.
}
\section{Request syntax}{
\preformatted{svc$update_product(
  AcceptLanguage = "string",
  Id = "string",
  Name = "string",
  Owner = "string",
  Description = "string",
  Distributor = "string",
  SupportDescription = "string",
  SupportEmail = "string",
  SupportUrl = "string",
  AddTags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  RemoveTags = list(
    "string"
  )
)
}
}

\keyword{internal}
