% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_metric_alarm}
\alias{cloudwatch_put_metric_alarm}
\title{Creates or updates an alarm and associates it with the specified metric,
metric math expression, or anomaly detection model}
\usage{
cloudwatch_put_metric_alarm(AlarmName, AlarmDescription, ActionsEnabled,
  OKActions, AlarmActions, InsufficientDataActions, MetricName, Namespace,
  Statistic, ExtendedStatistic, Dimensions, Period, Unit,
  EvaluationPeriods, DatapointsToAlarm, Threshold, ComparisonOperator,
  TreatMissingData, EvaluateLowSampleCountPercentile, Metrics, Tags,
  ThresholdMetricId)
}
\arguments{
\item{AlarmName}{[required] The name for the alarm. This name must be unique within your AWS
account.}

\item{AlarmDescription}{The description for the alarm.}

\item{ActionsEnabled}{Indicates whether actions should be executed during any changes to the
alarm state. The default is TRUE.}

\item{OKActions}{The actions to execute when this alarm transitions to an \code{OK} state from
any other state. Each action is specified as an Amazon Resource Name
(ARN).

Valid Values: \code{arn:aws:automate:<i>region</i>:ec2:stop} \|
\code{arn:aws:automate:<i>region</i>:ec2:terminate} \|
\code{arn:aws:automate:<i>region</i>:ec2:recover} \|
\code{arn:aws:automate:<i>region</i>:ec2:reboot} \|
\code{arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> } \|
\code{arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> }

Valid Values (for use with IAM roles):
\code{arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0}
\|
\code{arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0}
\|
\code{arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0}}

\item{AlarmActions}{The actions to execute when this alarm transitions to the \code{ALARM} state
from any other state. Each action is specified as an Amazon Resource
Name (ARN).

Valid Values: \code{arn:aws:automate:<i>region</i>:ec2:stop} \|
\code{arn:aws:automate:<i>region</i>:ec2:terminate} \|
\code{arn:aws:automate:<i>region</i>:ec2:recover} \|
\code{arn:aws:automate:<i>region</i>:ec2:reboot} \|
\code{arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> } \|
\code{arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> }

Valid Values (for use with IAM roles):
\code{arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0}
\|
\code{arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0}
\|
\code{arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0}}

\item{InsufficientDataActions}{The actions to execute when this alarm transitions to the
\code{INSUFFICIENT_DATA} state from any other state. Each action is specified
as an Amazon Resource Name (ARN).

Valid Values: \code{arn:aws:automate:<i>region</i>:ec2:stop} \|
\code{arn:aws:automate:<i>region</i>:ec2:terminate} \|
\code{arn:aws:automate:<i>region</i>:ec2:recover} \|
\code{arn:aws:automate:<i>region</i>:ec2:reboot} \|
\code{arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> } \|
\code{arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> }

Valid Values (for use with IAM roles):
\code{&gt;arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0}
\|
\code{arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0}
\|
\code{arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0}}

\item{MetricName}{The name for the metric associated with the alarm.

If you are creating an alarm based on a math expression, you cannot
specify this parameter, or any of the \code{Dimensions}, \code{Period},
\code{Namespace}, \code{Statistic}, or \code{ExtendedStatistic} parameters. Instead,
you specify all this information in the \code{Metrics} array.}

\item{Namespace}{The namespace for the metric associated specified in \code{MetricName}.}

\item{Statistic}{The statistic for the metric specified in \code{MetricName}, other than
percentile. For percentile statistics, use \code{ExtendedStatistic}. When you
call \code{PutMetricAlarm} and specify a \code{MetricName}, you must specify
either \code{Statistic} or \code{ExtendedStatistic,} but not both.}

\item{ExtendedStatistic}{The percentile statistic for the metric specified in \code{MetricName}.
Specify a value between p0.0 and p100. When you call \code{PutMetricAlarm}
and specify a \code{MetricName}, you must specify either \code{Statistic} or
\code{ExtendedStatistic,} but not both.}

\item{Dimensions}{The dimensions for the metric specified in \code{MetricName}.}

\item{Period}{The length, in seconds, used each time the metric specified in
\code{MetricName} is evaluated. Valid values are 10, 30, and any multiple of
60.

Be sure to specify 10 or 30 only for metrics that are stored by a
\code{PutMetricData} call with a \code{StorageResolution} of 1. If you specify a
period of 10 or 30 for a metric that does not have sub-minute
resolution, the alarm still attempts to gather data at the period rate
that you specify. In this case, it does not receive data for the
attempts that do not correspond to a one-minute data resolution, and the
alarm may often lapse into INSUFFICENT\_DATA status. Specifying 10 or 30
also sets this alarm as a high-resolution alarm, which has a higher
charge than other alarms. For more information about pricing, see
\href{https://aws.amazon.com/cloudwatch/pricing/}{Amazon CloudWatch Pricing}.

An alarm's total current evaluation period can be no longer than one
day, so \code{Period} multiplied by \code{EvaluationPeriods} cannot be more than
86,400 seconds.}

\item{Unit}{The unit of measure for the statistic. For example, the units for the
Amazon EC2 NetworkIn metric are Bytes because NetworkIn tracks the
number of bytes that an instance receives on all network interfaces. You
can also specify a unit when you create a custom metric. Units help
provide conceptual meaning to your data. Metric data points that specify
a unit of measure, such as Percent, are aggregated separately.

If you specify a unit, you must use a unit that is appropriate for the
metric. Otherwise, the CloudWatch alarm can get stuck in the
\code{INSUFFICIENT DATA} state.}

\item{EvaluationPeriods}{[required] The number of periods over which data is compared to the specified
threshold. If you are setting an alarm that requires that a number of
consecutive data points be breaching to trigger the alarm, this value
specifies that number. If you are setting an "M out of N" alarm, this
value is the N.

An alarm's total current evaluation period can be no longer than one
day, so this number multiplied by \code{Period} cannot be more than 86,400
seconds.}

\item{DatapointsToAlarm}{The number of datapoints that must be breaching to trigger the alarm.
This is used only if you are setting an "M out of N" alarm. In that
case, this value is the M. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation}{Evaluating an Alarm}
in the \emph{Amazon CloudWatch User Guide}.}

\item{Threshold}{The value against which the specified statistic is compared.}

\item{ComparisonOperator}{[required] The arithmetic operation to use when comparing the specified statistic
and threshold. The specified statistic value is used as the first
operand.

The values \code{LessThanLowerOrGreaterThanUpperThreshold},
\code{LessThanLowerThreshold}, and \code{GreaterThanUpperThreshold} are used only
for alarms based on anomaly detection models.}

\item{TreatMissingData}{Sets how this alarm is to handle missing data points. If
\code{TreatMissingData} is omitted, the default behavior of \code{missing} is
used. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data}{Configuring How CloudWatch Alarms Treats Missing Data}.

Valid Values: \code{breaching | notBreaching | ignore | missing}}

\item{EvaluateLowSampleCountPercentile}{Used only for alarms based on percentiles. If you specify \code{ignore}, the
alarm state does not change during periods with too few data points to
be statistically significant. If you specify \code{evaluate} or omit this
parameter, the alarm is always evaluated and possibly changes state no
matter how many data points are available. For more information, see
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples}{Percentile-Based CloudWatch Alarms and Low Data Samples}.

Valid Values: \code{evaluate | ignore}}

\item{Metrics}{An array of \code{MetricDataQuery} structures that enable you to create an
alarm based on the result of a metric math expression. Each item in the
\code{Metrics} array either retrieves a metric or performs a math expression.

One item in the \code{Metrics} array is the expression that the alarm
watches. You designate this expression by setting \code{ReturnValue} to true
for this object in the array. For more information, see MetricDataQuery.

If you use the \code{Metrics} parameter, you cannot include the \code{MetricName},
\code{Dimensions}, \code{Period}, \code{Namespace}, \code{Statistic}, or \code{ExtendedStatistic}
parameters of \code{PutMetricAlarm} in the same operation. Instead, you
retrieve the metrics you are using in your math expression as part of
the \code{Metrics} array.}

\item{Tags}{A list of key-value pairs to associate with the alarm. You can associate
as many as 50 tags with an alarm.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions, by granting a user permission to
access or change only resources with certain tag values.}

\item{ThresholdMetricId}{If this is an alarm based on an anomaly detection model, make this value
match the ID of the \code{ANOMALY_DETECTION_BAND} function.

For an example of how to use this parameter, see the \strong{Anomaly Detection
Model Alarm} example on this page.

If your alarm uses this parameter, it cannot have Auto Scaling actions.}
}
\description{
Creates or updates an alarm and associates it with the specified metric,
metric math expression, or anomaly detection model.
}
\details{
Alarms based on anomaly detection models cannot have Auto Scaling
actions.

When this operation creates an alarm, the alarm state is immediately set
to \code{INSUFFICIENT_DATA}. The alarm is then evaluated and its state is set
appropriately. Any actions associated with the new state are then
executed.

When you update an existing alarm, its state is left unchanged, but the
update completely overwrites the previous configuration of the alarm.

If you are an IAM user, you must have Amazon EC2 permissions for some
alarm operations:
\itemize{
\item \code{iam:CreateServiceLinkedRole} for all alarms with EC2 actions
\item \code{ec2:DescribeInstanceStatus} and \code{ec2:DescribeInstances} for all
alarms on EC2 instance status metrics
\item \code{ec2:StopInstances} for alarms with stop actions
\item \code{ec2:TerminateInstances} for alarms with terminate actions
\item No specific permissions are needed for alarms with recover actions
}

If you have read/write permissions for Amazon CloudWatch but not for
Amazon EC2, you can still create an alarm, but the stop or terminate
actions are not performed. However, if you are later granted the
required permissions, the alarm actions that you created earlier are
performed.

If you are using an IAM role (for example, an EC2 instance profile), you
cannot stop or terminate the instance using alarm actions. However, you
can still see the alarm state and perform any other actions such as
Amazon SNS notifications or Auto Scaling policies.

If you are using temporary security credentials granted using AWS STS,
you cannot stop or terminate an EC2 instance using alarm actions.

The first time you create an alarm in the AWS Management Console, the
CLI, or by using the PutMetricAlarm API, CloudWatch creates the
necessary service-linked role for you. The service-linked role is called
\code{AWSServiceRoleForCloudWatchEvents}. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role}{AWS service-linked role}.
}
\section{Request syntax}{
\preformatted{svc$put_metric_alarm(
  AlarmName = "string",
  AlarmDescription = "string",
  ActionsEnabled = TRUE|FALSE,
  OKActions = list(
    "string"
  ),
  AlarmActions = list(
    "string"
  ),
  InsufficientDataActions = list(
    "string"
  ),
  MetricName = "string",
  Namespace = "string",
  Statistic = "SampleCount"|"Average"|"Sum"|"Minimum"|"Maximum",
  ExtendedStatistic = "string",
  Dimensions = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  Period = 123,
  Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
  EvaluationPeriods = 123,
  DatapointsToAlarm = 123,
  Threshold = 123.0,
  ComparisonOperator = "GreaterThanOrEqualToThreshold"|"GreaterThanThreshold"|"LessThanThreshold"|"LessThanOrEqualToThreshold"|"LessThanLowerOrGreaterThanUpperThreshold"|"LessThanLowerThreshold"|"GreaterThanUpperThreshold",
  TreatMissingData = "string",
  EvaluateLowSampleCountPercentile = "string",
  Metrics = list(
    list(
      Id = "string",
      MetricStat = list(
        Metric = list(
          Namespace = "string",
          MetricName = "string",
          Dimensions = list(
            list(
              Name = "string",
              Value = "string"
            )
          )
        ),
        Period = 123,
        Stat = "string",
        Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
      ),
      Expression = "string",
      Label = "string",
      ReturnData = TRUE|FALSE
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  ThresholdMetricId = "string"
)
}
}

\keyword{internal}
