% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_create_group}
\alias{resourcegroups_create_group}
\title{Creates a group with a specified name, description, and resource query}
\usage{
resourcegroups_create_group(Name, Description, ResourceQuery, Tags)
}
\arguments{
\item{Name}{[required] The name of the group, which is the identifier of the group in other
operations. A resource group name cannot be updated after it is created.
A resource group name can have a maximum of 128 characters, including
letters, numbers, hyphens, dots, and underscores. The name cannot start
with \code{AWS} or \code{aws}; these are reserved. A resource group name must be
unique within your account.}

\item{Description}{The description of the resource group. Descriptions can have a maximum
of 511 characters, including letters, numbers, hyphens, underscores,
punctuation, and spaces.}

\item{ResourceQuery}{[required] The resource query that determines which AWS resources are members of
this group.}

\item{Tags}{The tags to add to the group. A tag is a string-to-string map of
key-value pairs. Tag keys can have a maximum character length of 128
characters, and tag values can have a maximum length of 256 characters.}
}
\description{
Creates a group with a specified name, description, and resource query.
}
\section{Request syntax}{
\preformatted{svc$create_group(
  Name = "string",
  Description = "string",
  ResourceQuery = list(
    Type = "TAG_FILTERS_1_0"|"CLOUDFORMATION_STACK_1_0",
    Query = "string"
  ),
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
