% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_update_license_configuration}
\alias{licensemanager_update_license_configuration}
\title{Modifies the attributes of an existing license configuration object}
\usage{
licensemanager_update_license_configuration(LicenseConfigurationArn,
  LicenseConfigurationStatus, LicenseRules, LicenseCount,
  LicenseCountHardLimit, Name, Description)
}
\arguments{
\item{LicenseConfigurationArn}{[required] ARN for a license configuration.}

\item{LicenseConfigurationStatus}{New status of the license configuration (\code{ACTIVE} or \code{INACTIVE}).}

\item{LicenseRules}{List of flexible text strings designating license rules.}

\item{LicenseCount}{New number of licenses managed by the license configuration.}

\item{LicenseCountHardLimit}{Sets the number of available licenses as a hard limit.}

\item{Name}{New name of the license configuration.}

\item{Description}{New human-friendly description of the license configuration.}
}
\description{
Modifies the attributes of an existing license configuration object. A
license configuration is an abstraction of a customer license agreement
that can be consumed and enforced by License Manager. Components include
specifications for the license type (Instances, cores, sockets, VCPUs),
tenancy (shared or Dedicated Host), host affinity (how long a VM is
associated with a host), the number of licenses purchased and used.
}
\section{Request syntax}{
\preformatted{svc$update_license_configuration(
  LicenseConfigurationArn = "string",
  LicenseConfigurationStatus = "AVAILABLE"|"DISABLED",
  LicenseRules = list(
    "string"
  ),
  LicenseCount = 123,
  LicenseCountHardLimit = TRUE|FALSE,
  Name = "string",
  Description = "string"
)
}
}

\keyword{internal}
