% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationinsights_service.R
\name{applicationinsights}
\alias{applicationinsights}
\title{Amazon CloudWatch Application Insights}
\usage{
applicationinsights()
}
\description{
Amazon CloudWatch Application Insights for .NET and SQL Server

Amazon CloudWatch Application Insights for .NET and SQL Server is a
service that helps you detect common problems with your .NET and SQL
Server-based applications. It enables you to pinpoint the source of
issues in your applications (built with technologies such as Microsoft
IIS, .NET, and Microsoft SQL Server), by providing key insights into
detected problems.

After you onboard your application, CloudWatch Application Insights for
.NET and SQL Server identifies, recommends, and sets up metrics and
logs. It continuously analyzes and correlates your metrics and logs for
unusual behavior to surface actionable problems with your application.
For example, if your application is slow and unresponsive and leading to
HTTP 500 errors in your Application Load Balancer (ALB), Application
Insights informs you that a memory pressure problem with your SQL Server
database is occurring. It bases this analysis on impactful metrics and
log errors.
}
\section{Operations}{

\tabular{ll}{
\link[=applicationinsights_create_application]{create_application} \tab Adds an application that is created from a resource group \cr
\link[=applicationinsights_create_component]{create_component} \tab Creates a custom component by grouping similar standalone instances to monitor \cr
\link[=applicationinsights_delete_application]{delete_application} \tab Removes the specified application from monitoring \cr
\link[=applicationinsights_delete_component]{delete_component} \tab Ungroups a custom component \cr
\link[=applicationinsights_describe_application]{describe_application} \tab Describes the application \cr
\link[=applicationinsights_describe_component]{describe_component} \tab Describes a component and lists the resources that are grouped together in a component \cr
\link[=applicationinsights_describe_component_configuration]{describe_component_configuration} \tab Describes the monitoring configuration of the component \cr
\link[=applicationinsights_describe_component_configuration_recommendation]{describe_component_configuration_recommendation} \tab Describes the recommended monitoring configuration of the component \cr
\link[=applicationinsights_describe_observation]{describe_observation} \tab Describes an anomaly or error with the application \cr
\link[=applicationinsights_describe_problem]{describe_problem} \tab Describes an application problem \cr
\link[=applicationinsights_describe_problem_observations]{describe_problem_observations} \tab Describes the anomalies or errors associated with the problem \cr
\link[=applicationinsights_list_applications]{list_applications} \tab Lists the IDs of the applications that you are monitoring \cr
\link[=applicationinsights_list_components]{list_components} \tab Lists the auto-grouped, standalone, and custom components of the application \cr
\link[=applicationinsights_list_problems]{list_problems} \tab Lists the problems with your application \cr
\link[=applicationinsights_update_component]{update_component} \tab Updates the custom component name and/or the list of resources that make up the component\cr
\link[=applicationinsights_update_component_configuration]{update_component_configuration} \tab Updates the monitoring configurations for the component
}
}

\examples{
\donttest{svc <- applicationinsights()
svc$create_application(
  Foo = 123
)}

}
