% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_automation_execution}
\alias{ssm_get_automation_execution}
\title{Get detailed information about a particular Automation execution}
\usage{
ssm_get_automation_execution(AutomationExecutionId)
}
\arguments{
\item{AutomationExecutionId}{[required] The unique identifier for an existing automation execution to examine.
The execution ID is returned by StartAutomationExecution when the
execution of an Automation document is initiated.}
}
\value{
A list with the following syntax:\preformatted{list(
  AutomationExecution = list(
    AutomationExecutionId = "string",
    DocumentName = "string",
    DocumentVersion = "string",
    ExecutionStartTime = as.POSIXct(
      "2015-01-01"
    ),
    ExecutionEndTime = as.POSIXct(
      "2015-01-01"
    ),
    AutomationExecutionStatus = "Pending"|"InProgress"|"Waiting"|"Success"|"TimedOut"|"Cancelling"|"Cancelled"|"Failed"|"PendingApproval"|"Approved"|"Rejected"|"Scheduled"|"RunbookInProgress"|"PendingChangeCalendarOverride"|"ChangeCalendarOverrideApproved"|"ChangeCalendarOverrideRejected"|"CompletedWithSuccess"|"CompletedWithFailure",
    StepExecutions = list(
      list(
        StepName = "string",
        Action = "string",
        TimeoutSeconds = 123,
        OnFailure = "string",
        MaxAttempts = 123,
        ExecutionStartTime = as.POSIXct(
          "2015-01-01"
        ),
        ExecutionEndTime = as.POSIXct(
          "2015-01-01"
        ),
        StepStatus = "Pending"|"InProgress"|"Waiting"|"Success"|"TimedOut"|"Cancelling"|"Cancelled"|"Failed"|"PendingApproval"|"Approved"|"Rejected"|"Scheduled"|"RunbookInProgress"|"PendingChangeCalendarOverride"|"ChangeCalendarOverrideApproved"|"ChangeCalendarOverrideRejected"|"CompletedWithSuccess"|"CompletedWithFailure",
        ResponseCode = "string",
        Inputs = list(
          "string"
        ),
        Outputs = list(
          list(
            "string"
          )
        ),
        Response = "string",
        FailureMessage = "string",
        FailureDetails = list(
          FailureStage = "string",
          FailureType = "string",
          Details = list(
            list(
              "string"
            )
          )
        ),
        StepExecutionId = "string",
        OverriddenParameters = list(
          list(
            "string"
          )
        ),
        IsEnd = TRUE|FALSE,
        NextStep = "string",
        IsCritical = TRUE|FALSE,
        ValidNextSteps = list(
          "string"
        ),
        Targets = list(
          list(
            Key = "string",
            Values = list(
              "string"
            )
          )
        ),
        TargetLocation = list(
          Accounts = list(
            "string"
          ),
          Regions = list(
            "string"
          ),
          TargetLocationMaxConcurrency = "string",
          TargetLocationMaxErrors = "string",
          ExecutionRoleName = "string"
        )
      )
    ),
    StepExecutionsTruncated = TRUE|FALSE,
    Parameters = list(
      list(
        "string"
      )
    ),
    Outputs = list(
      list(
        "string"
      )
    ),
    FailureMessage = "string",
    Mode = "Auto"|"Interactive",
    ParentAutomationExecutionId = "string",
    ExecutedBy = "string",
    CurrentStepName = "string",
    CurrentAction = "string",
    TargetParameterName = "string",
    Targets = list(
      list(
        Key = "string",
        Values = list(
          "string"
        )
      )
    ),
    TargetMaps = list(
      list(
        list(
          "string"
        )
      )
    ),
    ResolvedTargets = list(
      ParameterValues = list(
        "string"
      ),
      Truncated = TRUE|FALSE
    ),
    MaxConcurrency = "string",
    MaxErrors = "string",
    Target = "string",
    TargetLocations = list(
      list(
        Accounts = list(
          "string"
        ),
        Regions = list(
          "string"
        ),
        TargetLocationMaxConcurrency = "string",
        TargetLocationMaxErrors = "string",
        ExecutionRoleName = "string"
      )
    ),
    ProgressCounters = list(
      TotalSteps = 123,
      SuccessSteps = 123,
      FailedSteps = 123,
      CancelledSteps = 123,
      TimedOutSteps = 123
    ),
    AutomationSubtype = "ChangeRequest",
    ScheduledTime = as.POSIXct(
      "2015-01-01"
    ),
    Runbooks = list(
      list(
        DocumentName = "string",
        DocumentVersion = "string",
        Parameters = list(
          list(
            "string"
          )
        ),
        TargetParameterName = "string",
        Targets = list(
          list(
            Key = "string",
            Values = list(
              "string"
            )
          )
        ),
        MaxConcurrency = "string",
        MaxErrors = "string",
        TargetLocations = list(
          list(
            Accounts = list(
              "string"
            ),
            Regions = list(
              "string"
            ),
            TargetLocationMaxConcurrency = "string",
            TargetLocationMaxErrors = "string",
            ExecutionRoleName = "string"
          )
        )
      )
    ),
    OpsItemId = "string",
    AssociationId = "string",
    ChangeRequestName = "string"
  )
)
}
}
\description{
Get detailed information about a particular Automation execution.
}
\section{Request syntax}{
\preformatted{svc$get_automation_execution(
  AutomationExecutionId = "string"
)
}
}

\keyword{internal}
