% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_record_history}
\alias{servicecatalog_list_record_history}
\title{Lists the specified requests or all performed requests}
\usage{
servicecatalog_list_record_history(AcceptLanguage, AccessLevelFilter,
  SearchFilter, PageSize, PageToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{AccessLevelFilter}{The access level to use to obtain results. The default is \code{User}.}

\item{SearchFilter}{The search filter to scope the results.}

\item{PageSize}{The maximum number of items to return with this call.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}
}
\value{
A list with the following syntax:\preformatted{list(
  RecordDetails = list(
    list(
      RecordId = "string",
      ProvisionedProductName = "string",
      Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      UpdatedTime = as.POSIXct(
        "2015-01-01"
      ),
      ProvisionedProductType = "string",
      RecordType = "string",
      ProvisionedProductId = "string",
      ProductId = "string",
      ProvisioningArtifactId = "string",
      PathId = "string",
      RecordErrors = list(
        list(
          Code = "string",
          Description = "string"
        )
      ),
      RecordTags = list(
        list(
          Key = "string",
          Value = "string"
        )
      ),
      LaunchRoleArn = "string"
    )
  ),
  NextPageToken = "string"
)
}
}
\description{
Lists the specified requests or all performed requests.
}
\section{Request syntax}{
\preformatted{svc$list_record_history(
  AcceptLanguage = "string",
  AccessLevelFilter = list(
    Key = "Account"|"Role"|"User",
    Value = "string"
  ),
  SearchFilter = list(
    Key = "string",
    Value = "string"
  ),
  PageSize = 123,
  PageToken = "string"
)
}
}

\keyword{internal}
