% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_create_portfolio}
\alias{servicecatalog_create_portfolio}
\title{Creates a portfolio}
\usage{
servicecatalog_create_portfolio(AcceptLanguage, DisplayName,
  Description, ProviderName, Tags, IdempotencyToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{DisplayName}{[required] The name to use for display purposes.}

\item{Description}{The description of the portfolio.}

\item{ProviderName}{[required] The name of the portfolio provider.}

\item{Tags}{One or more tags.}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}
}
\value{
A list with the following syntax:\preformatted{list(
  PortfolioDetail = list(
    Id = "string",
    ARN = "string",
    DisplayName = "string",
    Description = "string",
    CreatedTime = as.POSIXct(
      "2015-01-01"
    ),
    ProviderName = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Creates a portfolio.

A delegated admin is authorized to invoke this command.
}
\section{Request syntax}{
\preformatted{svc$create_portfolio(
  AcceptLanguage = "string",
  DisplayName = "string",
  Description = "string",
  ProviderName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
