% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_user_profiles}
\alias{opsworks_describe_user_profiles}
\title{Describe specified users}
\usage{
opsworks_describe_user_profiles(IamUserArns)
}
\arguments{
\item{IamUserArns}{An array of IAM or federated user ARNs that identify the users to be
described.}
}
\value{
A list with the following syntax:\preformatted{list(
  UserProfiles = list(
    list(
      IamUserArn = "string",
      Name = "string",
      SshUsername = "string",
      SshPublicKey = "string",
      AllowSelfManagement = TRUE|FALSE
    )
  )
)
}
}
\description{
Describe specified users.

\strong{Required Permissions}: To use this action, an IAM user must have an
attached policy that explicitly grants permissions. For more information
about user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_user_profiles(
  IamUserArns = list(
    "string"
  )
)
}
}

\keyword{internal}
