% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_put_aggregation_authorization}
\alias{configservice_put_aggregation_authorization}
\title{Authorizes the aggregator account and region to collect data from the
source account and region}
\usage{
configservice_put_aggregation_authorization(AuthorizedAccountId,
  AuthorizedAwsRegion, Tags)
}
\arguments{
\item{AuthorizedAccountId}{[required] The 12-digit account ID of the account authorized to aggregate data.}

\item{AuthorizedAwsRegion}{[required] The region authorized to collect aggregated data.}

\item{Tags}{An array of tag object.}
}
\value{
A list with the following syntax:\preformatted{list(
  AggregationAuthorization = list(
    AggregationAuthorizationArn = "string",
    AuthorizedAccountId = "string",
    AuthorizedAwsRegion = "string",
    CreationTime = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Authorizes the aggregator account and region to collect data from the
source account and region.
}
\section{Request syntax}{
\preformatted{svc$put_aggregation_authorization(
  AuthorizedAccountId = "string",
  AuthorizedAwsRegion = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
