% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_compliance_details_by_resource}
\alias{configservice_get_compliance_details_by_resource}
\title{Returns the evaluation results for the specified AWS resource}
\usage{
configservice_get_compliance_details_by_resource(ResourceType,
  ResourceId, ComplianceTypes, NextToken)
}
\arguments{
\item{ResourceType}{[required] The type of the AWS resource for which you want compliance information.}

\item{ResourceId}{[required] The ID of the AWS resource for which you want compliance information.}

\item{ComplianceTypes}{Filters the results by compliance.

The allowed values are \code{COMPLIANT}, \code{NON_COMPLIANT}, and
\code{NOT_APPLICABLE}.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\value{
A list with the following syntax:\preformatted{list(
  EvaluationResults = list(
    list(
      EvaluationResultIdentifier = list(
        EvaluationResultQualifier = list(
          ConfigRuleName = "string",
          ResourceType = "string",
          ResourceId = "string"
        ),
        OrderingTimestamp = as.POSIXct(
          "2015-01-01"
        )
      ),
      ComplianceType = "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA",
      ResultRecordedTime = as.POSIXct(
        "2015-01-01"
      ),
      ConfigRuleInvokedTime = as.POSIXct(
        "2015-01-01"
      ),
      Annotation = "string",
      ResultToken = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns the evaluation results for the specified AWS resource. The
results indicate which AWS Config rules were used to evaluate the
resource, when each rule was last used, and whether the resource
complies with each rule.
}
\section{Request syntax}{
\preformatted{svc$get_compliance_details_by_resource(
  ResourceType = "string",
  ResourceId = "string",
  ComplianceTypes = list(
    "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA"
  ),
  NextToken = "string"
)
}
}

\keyword{internal}
