% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_get_dashboard}
\alias{cloudwatch_get_dashboard}
\title{Displays the details of the dashboard that you specify}
\usage{
cloudwatch_get_dashboard(DashboardName)
}
\arguments{
\item{DashboardName}{[required] The name of the dashboard to be described.}
}
\value{
A list with the following syntax:\preformatted{list(
  DashboardArn = "string",
  DashboardBody = "string",
  DashboardName = "string"
)
}
}
\description{
Displays the details of the dashboard that you specify.

To copy an existing dashboard, use
\code{\link[=cloudwatch_get_dashboard]{get_dashboard}}, and then use the data
returned within \code{DashboardBody} as the template for the new dashboard
when you call \code{\link[=cloudwatch_put_dashboard]{put_dashboard}} to create the
copy.
}
\section{Request syntax}{
\preformatted{svc$get_dashboard(
  DashboardName = "string"
)
}
}

\keyword{internal}
