% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_list_groups}
\alias{resourcegroups_list_groups}
\title{Returns a list of existing resource groups in your account}
\usage{
resourcegroups_list_groups(Filters, MaxResults, NextToken)
}
\arguments{
\item{Filters}{Filters, formatted as GroupFilter objects, that you want to apply to a
\code{\link[=resourcegroups_list_groups]{list_groups}} operation.
\itemize{
\item \code{resource-type} - Filter the results to include only those of the
specified resource types. Specify up to five resource types in the
format \verb{AWS::ServiceCode::ResourceType }. For example,
\verb{AWS::EC2::Instance}, or \verb{AWS::S3::Bucket}.
\item \code{configuration-type} - Filter the results to include only those
groups that have the specified configuration types attached. The
current supported values are:
\itemize{
\item \code{AWS:EC2::CapacityReservationPool}
\item \code{AWS:EC2::HostManagement}
}
}}

\item{MaxResults}{The total number of results that you want included on each page of the
response. If you do not include this parameter, it defaults to a value
that is specific to the operation. If additional items exist beyond the
maximum you specify, the \code{NextToken} response element is present and has
a value (is not null). Include that value as the \code{NextToken} request
parameter in the next call to the operation to get the next part of the
results. Note that the service might return fewer results than the
maximum even when there are more results available. You should check
\code{NextToken} after every operation to ensure that you receive all of the
results.}

\item{NextToken}{The parameter for receiving additional results if you receive a
\code{NextToken} response in a previous request. A \code{NextToken} response
indicates that more output is available. Set this parameter to the value
provided by a previous call's \code{NextToken} response to indicate where the
output should continue from.}
}
\value{
A list with the following syntax:\preformatted{list(
  GroupIdentifiers = list(
    list(
      GroupName = "string",
      GroupArn = "string"
    )
  ),
  Groups = list(
    list(
      GroupArn = "string",
      Name = "string",
      Description = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of existing resource groups in your account.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item \code{resource-groups:ListGroups}
}
}
\section{Request syntax}{
\preformatted{svc$list_groups(
  Filters = list(
    list(
      Name = "resource-type"|"configuration-type",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
