% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi_operations.R
\name{pi_describe_dimension_keys}
\alias{pi_describe_dimension_keys}
\title{For a specific time period, retrieve the top N dimension keys for a
metric}
\usage{
pi_describe_dimension_keys(ServiceType, Identifier, StartTime, EndTime,
  Metric, PeriodInSeconds, GroupBy, PartitionBy, Filter, MaxResults,
  NextToken)
}
\arguments{
\item{ServiceType}{[required] The AWS service for which Performance Insights will return metrics. The
only valid value for \emph{ServiceType} is \code{RDS}.}

\item{Identifier}{[required] An immutable, AWS Region-unique identifier for a data source.
Performance Insights gathers metrics from this data source.

To use an Amazon RDS instance as a data source, you specify its
\code{DbiResourceId} value. For example, specify
\code{db-FAIHNTYBKTGAUSUZQYPDS2GW4A}}

\item{StartTime}{[required] The date and time specifying the beginning of the requested time series
data. You must specify a \code{StartTime} within the past 7 days. The value
specified is \emph{inclusive}, which means that data points equal to or
greater than \code{StartTime} are returned.

The value for \code{StartTime} must be earlier than the value for \code{EndTime}.}

\item{EndTime}{[required] The date and time specifying the end of the requested time series data.
The value specified is \emph{exclusive}, which means that data points less
than (but not equal to) \code{EndTime} are returned.

The value for \code{EndTime} must be later than the value for \code{StartTime}.}

\item{Metric}{[required] The name of a Performance Insights metric to be measured.

Valid values for \code{Metric} are:
\itemize{
\item \code{db.load.avg} - a scaled representation of the number of active
sessions for the database engine.
\item \code{db.sampledload.avg} - the raw number of active sessions for the
database engine.
}

If the number of active sessions is less than an internal Performance
Insights threshold, \code{db.load.avg} and \code{db.sampledload.avg} are the same
value. If the number of active sessions is greater than the internal
threshold, Performance Insights samples the active sessions, with
\code{db.load.avg} showing the scaled values, \code{db.sampledload.avg} showing
the raw values, and \code{db.sampledload.avg} less than \code{db.load.avg}. For
most use cases, you can query \code{db.load.avg} only.}

\item{PeriodInSeconds}{The granularity, in seconds, of the data points returned from
Performance Insights. A period can be as short as one second, or as long
as one day (86400 seconds). Valid values are:
\itemize{
\item \code{1} (one second)
\item \code{60} (one minute)
\item \code{300} (five minutes)
\item \code{3600} (one hour)
\item \code{86400} (twenty-four hours)
}

If you don't specify \code{PeriodInSeconds}, then Performance Insights
chooses a value for you, with a goal of returning roughly 100-200 data
points in the response.}

\item{GroupBy}{[required] A specification for how to aggregate the data points from a query
result. You must specify a valid dimension group. Performance Insights
returns all dimensions within this group, unless you provide the names
of specific dimensions within this group. You can also request that
Performance Insights return a limited number of values for a dimension.}

\item{PartitionBy}{For each dimension specified in \code{GroupBy}, specify a secondary dimension
to further subdivide the partition keys in the response.}

\item{Filter}{One or more filters to apply in the request. Restrictions:
\itemize{
\item Any number of filters by the same dimension, as specified in the
\code{GroupBy} or \code{Partition} parameters.
\item A single filter for any other dimension in this dimension group.
}}

\item{MaxResults}{The maximum number of items to return in the response. If more items
exist than the specified \code{MaxRecords} value, a pagination token is
included in the response so that the remaining results can be retrieved.}

\item{NextToken}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
token, up to the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  AlignedStartTime = as.POSIXct(
    "2015-01-01"
  ),
  AlignedEndTime = as.POSIXct(
    "2015-01-01"
  ),
  PartitionKeys = list(
    list(
      Dimensions = list(
        "string"
      )
    )
  ),
  Keys = list(
    list(
      Dimensions = list(
        "string"
      ),
      Total = 123.0,
      Partitions = list(
        123.0
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
For a specific time period, retrieve the top \code{N} dimension keys for a
metric.

Each response element returns a maximum of 500 bytes. For larger
elements, such as SQL statements, only the first 500 bytes are returned.
}
\section{Request syntax}{
\preformatted{svc$describe_dimension_keys(
  ServiceType = "RDS",
  Identifier = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Metric = "string",
  PeriodInSeconds = 123,
  GroupBy = list(
    Group = "string",
    Dimensions = list(
      "string"
    ),
    Limit = 123
  ),
  PartitionBy = list(
    Group = "string",
    Dimensions = list(
      "string"
    ),
    Limit = 123
  ),
  Filter = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
