% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_create_user_profile}
\alias{opsworks_create_user_profile}
\title{Creates a new user profile}
\usage{
opsworks_create_user_profile(IamUserArn, SshUsername, SshPublicKey,
  AllowSelfManagement)
}
\arguments{
\item{IamUserArn}{[required] The user's IAM ARN; this can also be a federated user's ARN.}

\item{SshUsername}{The user's SSH user name. The allowable characters are [a-z], [A-Z],
[0-9], '-', and '_'. If the specified name includes other punctuation
marks, AWS OpsWorks Stacks removes them. For example, \code{my.name} will be
changed to \code{myname}. If you do not specify an SSH user name, AWS
OpsWorks Stacks generates one from the IAM user name.}

\item{SshPublicKey}{The user's public SSH key.}

\item{AllowSelfManagement}{Whether users can specify their own SSH public key through the My
Settings page. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html}{Setting an IAM User's Public SSH Key}.}
}
\value{
A list with the following syntax:\preformatted{list(
  IamUserArn = "string"
)
}
}
\description{
Creates a new user profile.

\strong{Required Permissions}: To use this action, an IAM user must have an
attached policy that explicitly grants permissions. For more information
about user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$create_user_profile(
  IamUserArn = "string",
  SshUsername = "string",
  SshPublicKey = "string",
  AllowSelfManagement = TRUE|FALSE
)
}
}

\keyword{internal}
