% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_metric_alarm}
\alias{cloudwatch_put_metric_alarm}
\title{Creates or updates an alarm and associates it with the specified metric,
metric math expression, or anomaly detection model}
\usage{
cloudwatch_put_metric_alarm(AlarmName, AlarmDescription, ActionsEnabled,
  OKActions, AlarmActions, InsufficientDataActions, MetricName, Namespace,
  Statistic, ExtendedStatistic, Dimensions, Period, Unit,
  EvaluationPeriods, DatapointsToAlarm, Threshold, ComparisonOperator,
  TreatMissingData, EvaluateLowSampleCountPercentile, Metrics, Tags,
  ThresholdMetricId)
}
\arguments{
\item{AlarmName}{[required] The name for the alarm. This name must be unique within the Region.}

\item{AlarmDescription}{The description for the alarm.}

\item{ActionsEnabled}{Indicates whether actions should be executed during any changes to the
alarm state. The default is \code{TRUE}.}

\item{OKActions}{The actions to execute when this alarm transitions to an \code{OK} state from
any other state. Each action is specified as an Amazon Resource Name
(ARN).

Valid Values: \code{arn:aws:automate:region:ec2:stop} |
\code{arn:aws:automate:region:ec2:terminate} |
\code{arn:aws:automate:region:ec2:recover} |
\code{arn:aws:automate:region:ec2:reboot} |
\code{arn:aws:sns:region:account-id:sns-topic-name } |
\code{arn:aws:autoscaling:region:account-id:scalingPolicy:policy-id:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name }

Valid Values (for use with IAM roles):
\code{arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0}
|
\code{arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0}
|
\code{arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0}}

\item{AlarmActions}{The actions to execute when this alarm transitions to the \code{ALARM} state
from any other state. Each action is specified as an Amazon Resource
Name (ARN).

Valid Values: \code{arn:aws:automate:region:ec2:stop} |
\code{arn:aws:automate:region:ec2:terminate} |
\code{arn:aws:automate:region:ec2:recover} |
\code{arn:aws:automate:region:ec2:reboot} |
\code{arn:aws:sns:region:account-id:sns-topic-name } |
\code{arn:aws:autoscaling:region:account-id:scalingPolicy:policy-id:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name }
| \code{arn:aws:ssm:region:account-id:opsitem:severity }

Valid Values (for use with IAM roles):
\code{arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0}
|
\code{arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0}
|
\code{arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0}}

\item{InsufficientDataActions}{The actions to execute when this alarm transitions to the
\code{INSUFFICIENT_DATA} state from any other state. Each action is specified
as an Amazon Resource Name (ARN).

Valid Values: \code{arn:aws:automate:region:ec2:stop} |
\code{arn:aws:automate:region:ec2:terminate} |
\code{arn:aws:automate:region:ec2:recover} |
\code{arn:aws:automate:region:ec2:reboot} |
\code{arn:aws:sns:region:account-id:sns-topic-name } |
\code{arn:aws:autoscaling:region:account-id:scalingPolicy:policy-id:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name }

Valid Values (for use with IAM roles):
\verb{>arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0}
|
\code{arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0}
|
\code{arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0}}

\item{MetricName}{The name for the metric associated with the alarm. For each
\code{\link[=cloudwatch_put_metric_alarm]{put_metric_alarm}} operation, you must
specify either \code{MetricName} or a \code{Metrics} array.

If you are creating an alarm based on a math expression, you cannot
specify this parameter, or any of the \code{Dimensions}, \code{Period},
\code{Namespace}, \code{Statistic}, or \code{ExtendedStatistic} parameters. Instead,
you specify all this information in the \code{Metrics} array.}

\item{Namespace}{The namespace for the metric associated specified in \code{MetricName}.}

\item{Statistic}{The statistic for the metric specified in \code{MetricName}, other than
percentile. For percentile statistics, use \code{ExtendedStatistic}. When you
call \code{\link[=cloudwatch_put_metric_alarm]{put_metric_alarm}} and specify a
\code{MetricName}, you must specify either \code{Statistic} or
\verb{ExtendedStatistic,} but not both.}

\item{ExtendedStatistic}{The percentile statistic for the metric specified in \code{MetricName}.
Specify a value between p0.0 and p100. When you call
\code{\link[=cloudwatch_put_metric_alarm]{put_metric_alarm}} and specify a
\code{MetricName}, you must specify either \code{Statistic} or
\verb{ExtendedStatistic,} but not both.}

\item{Dimensions}{The dimensions for the metric specified in \code{MetricName}.}

\item{Period}{The length, in seconds, used each time the metric specified in
\code{MetricName} is evaluated. Valid values are 10, 30, and any multiple of
60.

\code{Period} is required for alarms based on static thresholds. If you are
creating an alarm based on a metric math expression, you specify the
period for each metric within the objects in the \code{Metrics} array.

Be sure to specify 10 or 30 only for metrics that are stored by a
\code{\link[=cloudwatch_put_metric_data]{put_metric_data}} call with a
\code{StorageResolution} of 1. If you specify a period of 10 or 30 for a
metric that does not have sub-minute resolution, the alarm still
attempts to gather data at the period rate that you specify. In this
case, it does not receive data for the attempts that do not correspond
to a one-minute data resolution, and the alarm might often lapse into
INSUFFICENT_DATA status. Specifying 10 or 30 also sets this alarm as a
high-resolution alarm, which has a higher charge than other alarms. For
more information about pricing, see \href{https://aws.amazon.com/cloudwatch/pricing/}{Amazon CloudWatch Pricing}.

An alarm's total current evaluation period can be no longer than one
day, so \code{Period} multiplied by \code{EvaluationPeriods} cannot be more than
86,400 seconds.}

\item{Unit}{The unit of measure for the statistic. For example, the units for the
Amazon EC2 NetworkIn metric are Bytes because NetworkIn tracks the
number of bytes that an instance receives on all network interfaces. You
can also specify a unit when you create a custom metric. Units help
provide conceptual meaning to your data. Metric data points that specify
a unit of measure, such as Percent, are aggregated separately.

If you don't specify \code{Unit}, CloudWatch retrieves all unit types that
have been published for the metric and attempts to evaluate the alarm.
Usually, metrics are published with only one unit, so the alarm works as
intended.

However, if the metric is published with multiple types of units and you
don't specify a unit, the alarm's behavior is not defined and it behaves
predictably.

We recommend omitting \code{Unit} so that you don't inadvertently specify an
incorrect unit that is not published for this metric. Doing so causes
the alarm to be stuck in the \verb{INSUFFICIENT DATA} state.}

\item{EvaluationPeriods}{[required] The number of periods over which data is compared to the specified
threshold. If you are setting an alarm that requires that a number of
consecutive data points be breaching to trigger the alarm, this value
specifies that number. If you are setting an "M out of N" alarm, this
value is the N.

An alarm's total current evaluation period can be no longer than one
day, so this number multiplied by \code{Period} cannot be more than 86,400
seconds.}

\item{DatapointsToAlarm}{The number of data points that must be breaching to trigger the alarm.
This is used only if you are setting an "M out of N" alarm. In that
case, this value is the M. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation}{Evaluating an Alarm}
in the \emph{Amazon CloudWatch User Guide}.}

\item{Threshold}{The value against which the specified statistic is compared.

This parameter is required for alarms based on static thresholds, but
should not be used for alarms based on anomaly detection models.}

\item{ComparisonOperator}{[required] The arithmetic operation to use when comparing the specified statistic
and threshold. The specified statistic value is used as the first
operand.

The values \code{LessThanLowerOrGreaterThanUpperThreshold},
\code{LessThanLowerThreshold}, and \code{GreaterThanUpperThreshold} are used only
for alarms based on anomaly detection models.}

\item{TreatMissingData}{Sets how this alarm is to handle missing data points. If
\code{TreatMissingData} is omitted, the default behavior of \code{missing} is
used. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data}{Configuring How CloudWatch Alarms Treats Missing Data}.

Valid Values: \code{breaching | notBreaching | ignore | missing}}

\item{EvaluateLowSampleCountPercentile}{Used only for alarms based on percentiles. If you specify \code{ignore}, the
alarm state does not change during periods with too few data points to
be statistically significant. If you specify \code{evaluate} or omit this
parameter, the alarm is always evaluated and possibly changes state no
matter how many data points are available. For more information, see
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples}{Percentile-Based CloudWatch Alarms and Low Data Samples}.

Valid Values: \code{evaluate | ignore}}

\item{Metrics}{An array of \code{MetricDataQuery} structures that enable you to create an
alarm based on the result of a metric math expression. For each
\code{\link[=cloudwatch_put_metric_alarm]{put_metric_alarm}} operation, you must
specify either \code{MetricName} or a \code{Metrics} array.

Each item in the \code{Metrics} array either retrieves a metric or performs a
math expression.

One item in the \code{Metrics} array is the expression that the alarm
watches. You designate this expression by setting \code{ReturnData} to true
for this object in the array. For more information, see
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDataQuery.html}{MetricDataQuery}.

If you use the \code{Metrics} parameter, you cannot include the \code{MetricName},
\code{Dimensions}, \code{Period}, \code{Namespace}, \code{Statistic}, or \code{ExtendedStatistic}
parameters of \code{\link[=cloudwatch_put_metric_alarm]{put_metric_alarm}} in the
same operation. Instead, you retrieve the metrics you are using in your
math expression as part of the \code{Metrics} array.}

\item{Tags}{A list of key-value pairs to associate with the alarm. You can associate
as many as 50 tags with an alarm.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to
access or change only resources with certain tag values.

If you are using this operation to update an existing alarm, any tags
you specify in this parameter are ignored. To change the tags of an
existing alarm, use \code{\link[=cloudwatch_tag_resource]{tag_resource}} or
\code{\link[=cloudwatch_untag_resource]{untag_resource}}.}

\item{ThresholdMetricId}{If this is an alarm based on an anomaly detection model, make this value
match the ID of the \code{ANOMALY_DETECTION_BAND} function.

For an example of how to use this parameter, see the \strong{Anomaly Detection
Model Alarm} example on this page.

If your alarm uses this parameter, it cannot have Auto Scaling actions.}
}
\value{
An empty list.
}
\description{
Creates or updates an alarm and associates it with the specified metric,
metric math expression, or anomaly detection model.

Alarms based on anomaly detection models cannot have Auto Scaling
actions.

When this operation creates an alarm, the alarm state is immediately set
to \code{INSUFFICIENT_DATA}. The alarm is then evaluated and its state is set
appropriately. Any actions associated with the new state are then
executed.

When you update an existing alarm, its state is left unchanged, but the
update completely overwrites the previous configuration of the alarm.

If you are an IAM user, you must have Amazon EC2 permissions for some
alarm operations:
\itemize{
\item The \code{iam:CreateServiceLinkedRole} for all alarms with EC2 actions
\item The \code{iam:CreateServiceLinkedRole} to create an alarm with Systems
Manager OpsItem actions.
}

The first time you create an alarm in the AWS Management Console, the
CLI, or by using the PutMetricAlarm API, CloudWatch creates the
necessary service-linked rolea for you. The service-linked roles are
called \code{AWSServiceRoleForCloudWatchEvents} and
\code{AWSServiceRoleForCloudWatchAlarms_ActionSSM}. For more information, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role}{AWS service-linked role}.
}
\section{Request syntax}{
\preformatted{svc$put_metric_alarm(
  AlarmName = "string",
  AlarmDescription = "string",
  ActionsEnabled = TRUE|FALSE,
  OKActions = list(
    "string"
  ),
  AlarmActions = list(
    "string"
  ),
  InsufficientDataActions = list(
    "string"
  ),
  MetricName = "string",
  Namespace = "string",
  Statistic = "SampleCount"|"Average"|"Sum"|"Minimum"|"Maximum",
  ExtendedStatistic = "string",
  Dimensions = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  Period = 123,
  Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
  EvaluationPeriods = 123,
  DatapointsToAlarm = 123,
  Threshold = 123.0,
  ComparisonOperator = "GreaterThanOrEqualToThreshold"|"GreaterThanThreshold"|"LessThanThreshold"|"LessThanOrEqualToThreshold"|"LessThanLowerOrGreaterThanUpperThreshold"|"LessThanLowerThreshold"|"GreaterThanUpperThreshold",
  TreatMissingData = "string",
  EvaluateLowSampleCountPercentile = "string",
  Metrics = list(
    list(
      Id = "string",
      MetricStat = list(
        Metric = list(
          Namespace = "string",
          MetricName = "string",
          Dimensions = list(
            list(
              Name = "string",
              Value = "string"
            )
          )
        ),
        Period = 123,
        Stat = "string",
        Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
      ),
      Expression = "string",
      Label = "string",
      ReturnData = TRUE|FALSE,
      Period = 123
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  ThresholdMetricId = "string"
)
}
}

\keyword{internal}
