# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include autoscalingplans_service.R
NULL

#' Creates a scaling plan
#'
#' @description
#' Creates a scaling plan.
#'
#' @usage
#' autoscalingplans_create_scaling_plan(ScalingPlanName, ApplicationSource,
#'   ScalingInstructions)
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan. Names cannot contain vertical bars,
#' colons, or forward slashes.
#' @param ApplicationSource &#91;required&#93; A CloudFormation stack or set of tags. You can create one scaling plan
#' per application source.
#' 
#' For more information, see
#' [ApplicationSource](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html)
#' in the *AWS Auto Scaling API Reference*.
#' @param ScalingInstructions &#91;required&#93; The scaling instructions.
#' 
#' For more information, see
#' [ScalingInstruction](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html)
#' in the *AWS Auto Scaling API Reference*.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ScalingPlanVersion = 123
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_scaling_plan(
#'   ScalingPlanName = "string",
#'   ApplicationSource = list(
#'     CloudFormationStackARN = "string",
#'     TagFilters = list(
#'       list(
#'         Key = "string",
#'         Values = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   ScalingInstructions = list(
#'     list(
#'       ServiceNamespace = "autoscaling"|"ecs"|"ec2"|"rds"|"dynamodb",
#'       ResourceId = "string",
#'       ScalableDimension = "autoscaling:autoScalingGroup:DesiredCapacity"|"ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"rds:cluster:ReadReplicaCount"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits",
#'       MinCapacity = 123,
#'       MaxCapacity = 123,
#'       TargetTrackingConfigurations = list(
#'         list(
#'           PredefinedScalingMetricSpecification = list(
#'             PredefinedScalingMetricType = "ASGAverageCPUUtilization"|"ASGAverageNetworkIn"|"ASGAverageNetworkOut"|"DynamoDBReadCapacityUtilization"|"DynamoDBWriteCapacityUtilization"|"ECSServiceAverageCPUUtilization"|"ECSServiceAverageMemoryUtilization"|"ALBRequestCountPerTarget"|"RDSReaderAverageCPUUtilization"|"RDSReaderAverageDatabaseConnections"|"EC2SpotFleetRequestAverageCPUUtilization"|"EC2SpotFleetRequestAverageNetworkIn"|"EC2SpotFleetRequestAverageNetworkOut",
#'             ResourceLabel = "string"
#'           ),
#'           CustomizedScalingMetricSpecification = list(
#'             MetricName = "string",
#'             Namespace = "string",
#'             Dimensions = list(
#'               list(
#'                 Name = "string",
#'                 Value = "string"
#'               )
#'             ),
#'             Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'             Unit = "string"
#'           ),
#'           TargetValue = 123.0,
#'           DisableScaleIn = TRUE|FALSE,
#'           ScaleOutCooldown = 123,
#'           ScaleInCooldown = 123,
#'           EstimatedInstanceWarmup = 123
#'         )
#'       ),
#'       PredefinedLoadMetricSpecification = list(
#'         PredefinedLoadMetricType = "ASGTotalCPUUtilization"|"ASGTotalNetworkIn"|"ASGTotalNetworkOut"|"ALBTargetGroupRequestCount",
#'         ResourceLabel = "string"
#'       ),
#'       CustomizedLoadMetricSpecification = list(
#'         MetricName = "string",
#'         Namespace = "string",
#'         Dimensions = list(
#'           list(
#'             Name = "string",
#'             Value = "string"
#'           )
#'         ),
#'         Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'         Unit = "string"
#'       ),
#'       ScheduledActionBufferTime = 123,
#'       PredictiveScalingMaxCapacityBehavior = "SetForecastCapacityToMaxCapacity"|"SetMaxCapacityToForecastCapacity"|"SetMaxCapacityAboveForecastCapacity",
#'       PredictiveScalingMaxCapacityBuffer = 123,
#'       PredictiveScalingMode = "ForecastAndScale"|"ForecastOnly",
#'       ScalingPolicyUpdateBehavior = "KeepExternalPolicies"|"ReplaceExternalPolicies",
#'       DisableDynamicScaling = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_create_scaling_plan
autoscalingplans_create_scaling_plan <- function(ScalingPlanName, ApplicationSource, ScalingInstructions) {
  op <- new_operation(
    name = "CreateScalingPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$create_scaling_plan_input(ScalingPlanName = ScalingPlanName, ApplicationSource = ApplicationSource, ScalingInstructions = ScalingInstructions)
  output <- .autoscalingplans$create_scaling_plan_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$create_scaling_plan <- autoscalingplans_create_scaling_plan

#' Deletes the specified scaling plan
#'
#' @description
#' Deletes the specified scaling plan.
#' 
#' Deleting a scaling plan deletes the underlying ScalingInstruction for
#' all of the scalable resources that are covered by the plan.
#' 
#' If the plan has launched resources or has scaling activities in
#' progress, you must delete those resources separately.
#'
#' @usage
#' autoscalingplans_delete_scaling_plan(ScalingPlanName,
#'   ScalingPlanVersion)
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan.
#' @param ScalingPlanVersion &#91;required&#93; The version number of the scaling plan. Currently, the only valid value
#' is `1`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_scaling_plan(
#'   ScalingPlanName = "string",
#'   ScalingPlanVersion = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_delete_scaling_plan
autoscalingplans_delete_scaling_plan <- function(ScalingPlanName, ScalingPlanVersion) {
  op <- new_operation(
    name = "DeleteScalingPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$delete_scaling_plan_input(ScalingPlanName = ScalingPlanName, ScalingPlanVersion = ScalingPlanVersion)
  output <- .autoscalingplans$delete_scaling_plan_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$delete_scaling_plan <- autoscalingplans_delete_scaling_plan

#' Describes the scalable resources in the specified scaling plan
#'
#' @description
#' Describes the scalable resources in the specified scaling plan.
#'
#' @usage
#' autoscalingplans_describe_scaling_plan_resources(ScalingPlanName,
#'   ScalingPlanVersion, MaxResults, NextToken)
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan.
#' @param ScalingPlanVersion &#91;required&#93; The version number of the scaling plan. Currently, the only valid value
#' is `1`.
#' @param MaxResults The maximum number of scalable resources to return. The value must be
#' between 1 and 50. The default value is 50.
#' @param NextToken The token for the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ScalingPlanResources = list(
#'     list(
#'       ScalingPlanName = "string",
#'       ScalingPlanVersion = 123,
#'       ServiceNamespace = "autoscaling"|"ecs"|"ec2"|"rds"|"dynamodb",
#'       ResourceId = "string",
#'       ScalableDimension = "autoscaling:autoScalingGroup:DesiredCapacity"|"ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"rds:cluster:ReadReplicaCount"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits",
#'       ScalingPolicies = list(
#'         list(
#'           PolicyName = "string",
#'           PolicyType = "TargetTrackingScaling",
#'           TargetTrackingConfiguration = list(
#'             PredefinedScalingMetricSpecification = list(
#'               PredefinedScalingMetricType = "ASGAverageCPUUtilization"|"ASGAverageNetworkIn"|"ASGAverageNetworkOut"|"DynamoDBReadCapacityUtilization"|"DynamoDBWriteCapacityUtilization"|"ECSServiceAverageCPUUtilization"|"ECSServiceAverageMemoryUtilization"|"ALBRequestCountPerTarget"|"RDSReaderAverageCPUUtilization"|"RDSReaderAverageDatabaseConnections"|"EC2SpotFleetRequestAverageCPUUtilization"|"EC2SpotFleetRequestAverageNetworkIn"|"EC2SpotFleetRequestAverageNetworkOut",
#'               ResourceLabel = "string"
#'             ),
#'             CustomizedScalingMetricSpecification = list(
#'               MetricName = "string",
#'               Namespace = "string",
#'               Dimensions = list(
#'                 list(
#'                   Name = "string",
#'                   Value = "string"
#'                 )
#'               ),
#'               Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'               Unit = "string"
#'             ),
#'             TargetValue = 123.0,
#'             DisableScaleIn = TRUE|FALSE,
#'             ScaleOutCooldown = 123,
#'             ScaleInCooldown = 123,
#'             EstimatedInstanceWarmup = 123
#'           )
#'         )
#'       ),
#'       ScalingStatusCode = "Inactive"|"PartiallyActive"|"Active",
#'       ScalingStatusMessage = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_scaling_plan_resources(
#'   ScalingPlanName = "string",
#'   ScalingPlanVersion = 123,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_describe_scaling_plan_resources
autoscalingplans_describe_scaling_plan_resources <- function(ScalingPlanName, ScalingPlanVersion, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingPlanResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$describe_scaling_plan_resources_input(ScalingPlanName = ScalingPlanName, ScalingPlanVersion = ScalingPlanVersion, MaxResults = MaxResults, NextToken = NextToken)
  output <- .autoscalingplans$describe_scaling_plan_resources_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$describe_scaling_plan_resources <- autoscalingplans_describe_scaling_plan_resources

#' Describes one or more of your scaling plans
#'
#' @description
#' Describes one or more of your scaling plans.
#'
#' @usage
#' autoscalingplans_describe_scaling_plans(ScalingPlanNames,
#'   ScalingPlanVersion, ApplicationSources, MaxResults, NextToken)
#'
#' @param ScalingPlanNames The names of the scaling plans (up to 10). If you specify application
#' sources, you cannot specify scaling plan names.
#' @param ScalingPlanVersion The version number of the scaling plan. Currently, the only valid value
#' is `1`.
#' 
#' If you specify a scaling plan version, you must also specify a scaling
#' plan name.
#' @param ApplicationSources The sources for the applications (up to 10). If you specify scaling plan
#' names, you cannot specify application sources.
#' @param MaxResults The maximum number of scalable resources to return. This value can be
#' between 1 and 50. The default value is 50.
#' @param NextToken The token for the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ScalingPlans = list(
#'     list(
#'       ScalingPlanName = "string",
#'       ScalingPlanVersion = 123,
#'       ApplicationSource = list(
#'         CloudFormationStackARN = "string",
#'         TagFilters = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       ScalingInstructions = list(
#'         list(
#'           ServiceNamespace = "autoscaling"|"ecs"|"ec2"|"rds"|"dynamodb",
#'           ResourceId = "string",
#'           ScalableDimension = "autoscaling:autoScalingGroup:DesiredCapacity"|"ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"rds:cluster:ReadReplicaCount"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits",
#'           MinCapacity = 123,
#'           MaxCapacity = 123,
#'           TargetTrackingConfigurations = list(
#'             list(
#'               PredefinedScalingMetricSpecification = list(
#'                 PredefinedScalingMetricType = "ASGAverageCPUUtilization"|"ASGAverageNetworkIn"|"ASGAverageNetworkOut"|"DynamoDBReadCapacityUtilization"|"DynamoDBWriteCapacityUtilization"|"ECSServiceAverageCPUUtilization"|"ECSServiceAverageMemoryUtilization"|"ALBRequestCountPerTarget"|"RDSReaderAverageCPUUtilization"|"RDSReaderAverageDatabaseConnections"|"EC2SpotFleetRequestAverageCPUUtilization"|"EC2SpotFleetRequestAverageNetworkIn"|"EC2SpotFleetRequestAverageNetworkOut",
#'                 ResourceLabel = "string"
#'               ),
#'               CustomizedScalingMetricSpecification = list(
#'                 MetricName = "string",
#'                 Namespace = "string",
#'                 Dimensions = list(
#'                   list(
#'                     Name = "string",
#'                     Value = "string"
#'                   )
#'                 ),
#'                 Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'                 Unit = "string"
#'               ),
#'               TargetValue = 123.0,
#'               DisableScaleIn = TRUE|FALSE,
#'               ScaleOutCooldown = 123,
#'               ScaleInCooldown = 123,
#'               EstimatedInstanceWarmup = 123
#'             )
#'           ),
#'           PredefinedLoadMetricSpecification = list(
#'             PredefinedLoadMetricType = "ASGTotalCPUUtilization"|"ASGTotalNetworkIn"|"ASGTotalNetworkOut"|"ALBTargetGroupRequestCount",
#'             ResourceLabel = "string"
#'           ),
#'           CustomizedLoadMetricSpecification = list(
#'             MetricName = "string",
#'             Namespace = "string",
#'             Dimensions = list(
#'               list(
#'                 Name = "string",
#'                 Value = "string"
#'               )
#'             ),
#'             Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'             Unit = "string"
#'           ),
#'           ScheduledActionBufferTime = 123,
#'           PredictiveScalingMaxCapacityBehavior = "SetForecastCapacityToMaxCapacity"|"SetMaxCapacityToForecastCapacity"|"SetMaxCapacityAboveForecastCapacity",
#'           PredictiveScalingMaxCapacityBuffer = 123,
#'           PredictiveScalingMode = "ForecastAndScale"|"ForecastOnly",
#'           ScalingPolicyUpdateBehavior = "KeepExternalPolicies"|"ReplaceExternalPolicies",
#'           DisableDynamicScaling = TRUE|FALSE
#'         )
#'       ),
#'       StatusCode = "Active"|"ActiveWithProblems"|"CreationInProgress"|"CreationFailed"|"DeletionInProgress"|"DeletionFailed"|"UpdateInProgress"|"UpdateFailed",
#'       StatusMessage = "string",
#'       StatusStartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_scaling_plans(
#'   ScalingPlanNames = list(
#'     "string"
#'   ),
#'   ScalingPlanVersion = 123,
#'   ApplicationSources = list(
#'     list(
#'       CloudFormationStackARN = "string",
#'       TagFilters = list(
#'         list(
#'           Key = "string",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_describe_scaling_plans
autoscalingplans_describe_scaling_plans <- function(ScalingPlanNames = NULL, ScalingPlanVersion = NULL, ApplicationSources = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingPlans",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$describe_scaling_plans_input(ScalingPlanNames = ScalingPlanNames, ScalingPlanVersion = ScalingPlanVersion, ApplicationSources = ApplicationSources, MaxResults = MaxResults, NextToken = NextToken)
  output <- .autoscalingplans$describe_scaling_plans_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$describe_scaling_plans <- autoscalingplans_describe_scaling_plans

#' Retrieves the forecast data for a scalable resource
#'
#' @description
#' Retrieves the forecast data for a scalable resource.
#' 
#' Capacity forecasts are represented as predicted values, or data points,
#' that are calculated using historical data points from a specified
#' CloudWatch load metric. Data points are available for up to 56 days.
#'
#' @usage
#' autoscalingplans_get_scaling_plan_resource_forecast_data(
#'   ScalingPlanName, ScalingPlanVersion, ServiceNamespace, ResourceId,
#'   ScalableDimension, ForecastDataType, StartTime, EndTime)
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan.
#' @param ScalingPlanVersion &#91;required&#93; The version number of the scaling plan. Currently, the only valid value
#' is `1`.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service. The only valid value is `autoscaling`.
#' @param ResourceId &#91;required&#93; The ID of the resource. This string consists of a prefix
#' (`autoScalingGroup`) followed by the name of a specified Auto Scaling
#' group (`my-asg`). Example: `autoScalingGroup/my-asg`.
#' @param ScalableDimension &#91;required&#93; The scalable dimension for the resource. The only valid value is
#' `autoscaling:autoScalingGroup:DesiredCapacity`.
#' @param ForecastDataType &#91;required&#93; The type of forecast data to get.
#' 
#' -   `LoadForecast`: The load metric forecast.
#' 
#' -   `CapacityForecast`: The capacity forecast.
#' 
#' -   `ScheduledActionMinCapacity`: The minimum capacity for each
#'     scheduled scaling action. This data is calculated as the larger of
#'     two values: the capacity forecast or the minimum capacity in the
#'     scaling instruction.
#' 
#' -   `ScheduledActionMaxCapacity`: The maximum capacity for each
#'     scheduled scaling action. The calculation used is determined by the
#'     predictive scaling maximum capacity behavior setting in the scaling
#'     instruction.
#' @param StartTime &#91;required&#93; The inclusive start time of the time range for the forecast data to get.
#' The date and time can be at most 56 days before the current date and
#' time.
#' @param EndTime &#91;required&#93; The exclusive end time of the time range for the forecast data to get.
#' The maximum time duration between the start and end time is seven days.
#' 
#' Although this parameter can accept a date and time that is more than two
#' days in the future, the availability of forecast data has limits. AWS
#' Auto Scaling only issues forecasts for periods of two days in advance.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Datapoints = list(
#'     list(
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Value = 123.0
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_scaling_plan_resource_forecast_data(
#'   ScalingPlanName = "string",
#'   ScalingPlanVersion = 123,
#'   ServiceNamespace = "autoscaling"|"ecs"|"ec2"|"rds"|"dynamodb",
#'   ResourceId = "string",
#'   ScalableDimension = "autoscaling:autoScalingGroup:DesiredCapacity"|"ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"rds:cluster:ReadReplicaCount"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits",
#'   ForecastDataType = "CapacityForecast"|"LoadForecast"|"ScheduledActionMinCapacity"|"ScheduledActionMaxCapacity",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_get_scaling_plan_resource_forecast_data
autoscalingplans_get_scaling_plan_resource_forecast_data <- function(ScalingPlanName, ScalingPlanVersion, ServiceNamespace, ResourceId, ScalableDimension, ForecastDataType, StartTime, EndTime) {
  op <- new_operation(
    name = "GetScalingPlanResourceForecastData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$get_scaling_plan_resource_forecast_data_input(ScalingPlanName = ScalingPlanName, ScalingPlanVersion = ScalingPlanVersion, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, ForecastDataType = ForecastDataType, StartTime = StartTime, EndTime = EndTime)
  output <- .autoscalingplans$get_scaling_plan_resource_forecast_data_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$get_scaling_plan_resource_forecast_data <- autoscalingplans_get_scaling_plan_resource_forecast_data

#' Updates the specified scaling plan
#'
#' @description
#' Updates the specified scaling plan.
#' 
#' You cannot update a scaling plan if it is in the process of being
#' created, updated, or deleted.
#'
#' @usage
#' autoscalingplans_update_scaling_plan(ScalingPlanName,
#'   ScalingPlanVersion, ApplicationSource, ScalingInstructions)
#'
#' @param ScalingPlanName &#91;required&#93; The name of the scaling plan.
#' @param ScalingPlanVersion &#91;required&#93; The version number of the scaling plan. The only valid value is `1`.
#' Currently, you cannot have multiple scaling plan versions.
#' @param ApplicationSource A CloudFormation stack or set of tags.
#' 
#' For more information, see
#' [ApplicationSource](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html)
#' in the *AWS Auto Scaling API Reference*.
#' @param ScalingInstructions The scaling instructions.
#' 
#' For more information, see
#' [ScalingInstruction](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html)
#' in the *AWS Auto Scaling API Reference*.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_scaling_plan(
#'   ScalingPlanName = "string",
#'   ScalingPlanVersion = 123,
#'   ApplicationSource = list(
#'     CloudFormationStackARN = "string",
#'     TagFilters = list(
#'       list(
#'         Key = "string",
#'         Values = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   ScalingInstructions = list(
#'     list(
#'       ServiceNamespace = "autoscaling"|"ecs"|"ec2"|"rds"|"dynamodb",
#'       ResourceId = "string",
#'       ScalableDimension = "autoscaling:autoScalingGroup:DesiredCapacity"|"ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"rds:cluster:ReadReplicaCount"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits",
#'       MinCapacity = 123,
#'       MaxCapacity = 123,
#'       TargetTrackingConfigurations = list(
#'         list(
#'           PredefinedScalingMetricSpecification = list(
#'             PredefinedScalingMetricType = "ASGAverageCPUUtilization"|"ASGAverageNetworkIn"|"ASGAverageNetworkOut"|"DynamoDBReadCapacityUtilization"|"DynamoDBWriteCapacityUtilization"|"ECSServiceAverageCPUUtilization"|"ECSServiceAverageMemoryUtilization"|"ALBRequestCountPerTarget"|"RDSReaderAverageCPUUtilization"|"RDSReaderAverageDatabaseConnections"|"EC2SpotFleetRequestAverageCPUUtilization"|"EC2SpotFleetRequestAverageNetworkIn"|"EC2SpotFleetRequestAverageNetworkOut",
#'             ResourceLabel = "string"
#'           ),
#'           CustomizedScalingMetricSpecification = list(
#'             MetricName = "string",
#'             Namespace = "string",
#'             Dimensions = list(
#'               list(
#'                 Name = "string",
#'                 Value = "string"
#'               )
#'             ),
#'             Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'             Unit = "string"
#'           ),
#'           TargetValue = 123.0,
#'           DisableScaleIn = TRUE|FALSE,
#'           ScaleOutCooldown = 123,
#'           ScaleInCooldown = 123,
#'           EstimatedInstanceWarmup = 123
#'         )
#'       ),
#'       PredefinedLoadMetricSpecification = list(
#'         PredefinedLoadMetricType = "ASGTotalCPUUtilization"|"ASGTotalNetworkIn"|"ASGTotalNetworkOut"|"ALBTargetGroupRequestCount",
#'         ResourceLabel = "string"
#'       ),
#'       CustomizedLoadMetricSpecification = list(
#'         MetricName = "string",
#'         Namespace = "string",
#'         Dimensions = list(
#'           list(
#'             Name = "string",
#'             Value = "string"
#'           )
#'         ),
#'         Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'         Unit = "string"
#'       ),
#'       ScheduledActionBufferTime = 123,
#'       PredictiveScalingMaxCapacityBehavior = "SetForecastCapacityToMaxCapacity"|"SetMaxCapacityToForecastCapacity"|"SetMaxCapacityAboveForecastCapacity",
#'       PredictiveScalingMaxCapacityBuffer = 123,
#'       PredictiveScalingMode = "ForecastAndScale"|"ForecastOnly",
#'       ScalingPolicyUpdateBehavior = "KeepExternalPolicies"|"ReplaceExternalPolicies",
#'       DisableDynamicScaling = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname autoscalingplans_update_scaling_plan
autoscalingplans_update_scaling_plan <- function(ScalingPlanName, ScalingPlanVersion, ApplicationSource = NULL, ScalingInstructions = NULL) {
  op <- new_operation(
    name = "UpdateScalingPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscalingplans$update_scaling_plan_input(ScalingPlanName = ScalingPlanName, ScalingPlanVersion = ScalingPlanVersion, ApplicationSource = ApplicationSource, ScalingInstructions = ScalingInstructions)
  output <- .autoscalingplans$update_scaling_plan_output()
  config <- get_config()
  svc <- .autoscalingplans$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscalingplans$operations$update_scaling_plan <- autoscalingplans_update_scaling_plan
