% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_list_guardrails}
\alias{bedrock_list_guardrails}
\title{Lists details about all the guardrails in an account}
\usage{
bedrock_list_guardrails(
  guardrailIdentifier = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{guardrailIdentifier}{The unique identifier of the guardrail. This can be an ID or the ARN.}

\item{maxResults}{The maximum number of results to return in the response.}

\item{nextToken}{If there are more results than were returned in the response, the
response returns a \code{nextToken} that you can send in another
\code{\link[=bedrock_list_guardrails]{list_guardrails}} request to see the next
batch of results.}
}
\description{
Lists details about all the guardrails in an account. To list the \code{DRAFT} version of all your guardrails, don't specify the \code{guardrailIdentifier} field. To list all versions of a guardrail, specify the ARN of the guardrail in the \code{guardrailIdentifier} field.

See \url{https://www.paws-r-sdk.com/docs/bedrock_list_guardrails/} for full documentation.
}
\keyword{internal}
