% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutequipment_operations.R
\name{lookoutequipment_create_model}
\alias{lookoutequipment_create_model}
\title{Creates an ML model for data inference}
\usage{
lookoutequipment_create_model(
  ModelName,
  DatasetName,
  DatasetSchema = NULL,
  LabelsInputConfiguration = NULL,
  ClientToken,
  TrainingDataStartTime = NULL,
  TrainingDataEndTime = NULL,
  EvaluationDataStartTime = NULL,
  EvaluationDataEndTime = NULL,
  RoleArn = NULL,
  DataPreProcessingConfiguration = NULL,
  ServerSideKmsKeyId = NULL,
  Tags = NULL,
  OffCondition = NULL
)
}
\arguments{
\item{ModelName}{[required] The name for the ML model to be created.}

\item{DatasetName}{[required] The name of the dataset for the ML model being created.}

\item{DatasetSchema}{The data schema for the ML model being created.}

\item{LabelsInputConfiguration}{The input configuration for the labels being used for the ML model
that's being created.}

\item{ClientToken}{[required] A unique identifier for the request. If you do not set the client
request token, Amazon Lookout for Equipment generates one.}

\item{TrainingDataStartTime}{Indicates the time reference in the dataset that should be used to begin
the subset of training data for the ML model.}

\item{TrainingDataEndTime}{Indicates the time reference in the dataset that should be used to end
the subset of training data for the ML model.}

\item{EvaluationDataStartTime}{Indicates the time reference in the dataset that should be used to begin
the subset of evaluation data for the ML model.}

\item{EvaluationDataEndTime}{Indicates the time reference in the dataset that should be used to end
the subset of evaluation data for the ML model.}

\item{RoleArn}{The Amazon Resource Name (ARN) of a role with permission to access the
data source being used to create the ML model.}

\item{DataPreProcessingConfiguration}{The configuration is the \code{TargetSamplingRate}, which is the sampling
rate of the data after post processing by Amazon Lookout for Equipment.
For example, if you provide data that has been collected at a 1 second
level and you want the system to resample the data at a 1 minute rate
before training, the \code{TargetSamplingRate} is 1 minute.

When providing a value for the \code{TargetSamplingRate}, you must attach the
prefix "PT" to the rate you want. The value for a 1 second rate is
therefore \emph{PT1S}, the value for a 15 minute rate is \emph{PT15M}, and the
value for a 1 hour rate is \emph{PT1H}}

\item{ServerSideKmsKeyId}{Provides the identifier of the KMS key used to encrypt model data by
Amazon Lookout for Equipment.}

\item{Tags}{Any tags associated with the ML model being created.}

\item{OffCondition}{Indicates that the asset associated with this sensor has been shut off.
As long as this condition is met, Lookout for Equipment will not use
data from this asset for training, evaluation, or inference.}
}
\description{
Creates an ML model for data inference.

See \url{https://www.paws-r-sdk.com/docs/lookoutequipment_create_model/} for full documentation.
}
\keyword{internal}
