% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_update_model_version}
\alias{frauddetector_update_model_version}
\title{Updates a model version}
\usage{
frauddetector_update_model_version(
  modelId,
  modelType,
  majorVersionNumber,
  externalEventsDetail = NULL,
  ingestedEventsDetail = NULL,
  tags = NULL
)
}
\arguments{
\item{modelId}{[required] The model ID.}

\item{modelType}{[required] The model type.}

\item{majorVersionNumber}{[required] The major version number.}

\item{externalEventsDetail}{The details of the external events data used for training the model
version. Required if \code{trainingDataSource} is \code{EXTERNAL_EVENTS}.}

\item{ingestedEventsDetail}{The details of the ingested event used for training the model version.
Required if your \code{trainingDataSource} is \code{INGESTED_EVENTS}.}

\item{tags}{A collection of key and value pairs.}
}
\description{
Updates a model version. Updating a model version retrains an existing model version using updated training data and produces a new minor version of the model. You can update the training data set location and data access role attributes using this action. This action creates and trains a new minor version of the model, for example version 1.01, 1.02, 1.03.

See \url{https://paws-r.github.io/docs/frauddetector/update_model_version.html} for full documentation.
}
\keyword{internal}
