% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_list_predictors}
\alias{forecastservice_list_predictors}
\title{Returns a list of predictors created using the CreateAutoPredictor or
CreatePredictor operations}
\usage{
forecastservice_list_predictors(
  NextToken = NULL,
  MaxResults = NULL,
  Filters = NULL
)
}
\arguments{
\item{NextToken}{If the result of the previous request was truncated, the response
includes a \code{NextToken}. To retrieve the next set of results, use the
token in the next request. Tokens expire after 24 hours.}

\item{MaxResults}{The number of items to return in the response.}

\item{Filters}{An array of filters. For each filter, you provide a condition and a
match statement. The condition is either \code{IS} or \code{IS_NOT}, which
specifies whether to include or exclude the predictors that match the
statement from the list, respectively. The match statement consists of a
key and a value.

\strong{Filter properties}
\itemize{
\item \code{Condition} - The condition to apply. Valid values are \code{IS} and
\code{IS_NOT}. To include the predictors that match the statement,
specify \code{IS}. To exclude matching predictors, specify \code{IS_NOT}.
\item \code{Key} - The name of the parameter to filter on. Valid values are
\code{DatasetGroupArn} and \code{Status}.
\item \code{Value} - The value to match.
}

For example, to list all predictors whose status is ACTIVE, you would
specify:

\verb{"Filters": [ \{ "Condition": "IS", "Key": "Status", "Value": "ACTIVE" \} ]}}
}
\description{
Returns a list of predictors created using the \code{\link[=forecastservice_create_auto_predictor]{create_auto_predictor}} or \code{\link[=forecastservice_create_predictor]{create_predictor}} operations. For each predictor, this operation returns a summary of its properties, including its Amazon Resource Name (ARN).

See \url{https://paws-r.github.io/docs/forecastservice/list_predictors.html} for full documentation.
}
\keyword{internal}
