# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include comprehendmedical_service.R
NULL

#' Gets the properties associated with a medical entities detection job
#'
#' @description
#' Gets the properties associated with a medical entities detection job. Use this operation to get the status of a detection job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/describe_entities_detection_v2_job.html](https://paws-r.github.io/docs/comprehendmedical/describe_entities_detection_v2_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier that Comprehend Medical; generated for the job. The
#' [`start_entities_detection_v2_job`][comprehendmedical_start_entities_detection_v2_job]
#' operation returns this identifier in its response.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_describe_entities_detection_v2_job
comprehendmedical_describe_entities_detection_v2_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeEntitiesDetectionV2Job",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$describe_entities_detection_v2_job_input(JobId = JobId)
  output <- .comprehendmedical$describe_entities_detection_v2_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$describe_entities_detection_v2_job <- comprehendmedical_describe_entities_detection_v2_job

#' Gets the properties associated with an InferICD10CM job
#'
#' @description
#' Gets the properties associated with an InferICD10CM job. Use this operation to get the status of an inference job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/describe_icd10cm_inference_job.html](https://paws-r.github.io/docs/comprehendmedical/describe_icd10cm_inference_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Comprehend Medical generated for the job.
#' `The StartICD10CMInferenceJob` operation returns this identifier in its
#' response.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_describe_icd10cm_inference_job
comprehendmedical_describe_icd10cm_inference_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeICD10CMInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$describe_icd10cm_inference_job_input(JobId = JobId)
  output <- .comprehendmedical$describe_icd10cm_inference_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$describe_icd10cm_inference_job <- comprehendmedical_describe_icd10cm_inference_job

#' Gets the properties associated with a protected health information (PHI)
#' detection job
#'
#' @description
#' Gets the properties associated with a protected health information (PHI) detection job. Use this operation to get the status of a detection job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/describe_phi_detection_job.html](https://paws-r.github.io/docs/comprehendmedical/describe_phi_detection_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier that Comprehend Medical; generated for the job. The
#' [`start_phi_detection_job`][comprehendmedical_start_phi_detection_job]
#' operation returns this identifier in its response.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_describe_phi_detection_job
comprehendmedical_describe_phi_detection_job <- function(JobId) {
  op <- new_operation(
    name = "DescribePHIDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$describe_phi_detection_job_input(JobId = JobId)
  output <- .comprehendmedical$describe_phi_detection_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$describe_phi_detection_job <- comprehendmedical_describe_phi_detection_job

#' Gets the properties associated with an InferRxNorm job
#'
#' @description
#' Gets the properties associated with an InferRxNorm job. Use this operation to get the status of an inference job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/describe_rx_norm_inference_job.html](https://paws-r.github.io/docs/comprehendmedical/describe_rx_norm_inference_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Comprehend Medical generated for the job. The
#' StartRxNormInferenceJob operation returns this identifier in its
#' response.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_describe_rx_norm_inference_job
comprehendmedical_describe_rx_norm_inference_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeRxNormInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$describe_rx_norm_inference_job_input(JobId = JobId)
  output <- .comprehendmedical$describe_rx_norm_inference_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$describe_rx_norm_inference_job <- comprehendmedical_describe_rx_norm_inference_job

#' Gets the properties associated with an InferSNOMEDCT job
#'
#' @description
#' Gets the properties associated with an InferSNOMEDCT job. Use this operation to get the status of an inference job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/describe_snomedct_inference_job.html](https://paws-r.github.io/docs/comprehendmedical/describe_snomedct_inference_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier that Amazon Comprehend Medical generated for the job. The
#' StartSNOMEDCTInferenceJob operation returns this identifier in its
#' response.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_describe_snomedct_inference_job
comprehendmedical_describe_snomedct_inference_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeSNOMEDCTInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$describe_snomedct_inference_job_input(JobId = JobId)
  output <- .comprehendmedical$describe_snomedct_inference_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$describe_snomedct_inference_job <- comprehendmedical_describe_snomedct_inference_job

#' The DetectEntities operation is deprecated
#'
#' @description
#' The [`detect_entities`][comprehendmedical_detect_entities] operation is deprecated. You should use the [`detect_entities_v2`][comprehendmedical_detect_entities_v2] operation instead.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/detect_entities.html](https://paws-r.github.io/docs/comprehendmedical/detect_entities.html) for full documentation.
#'
#' @param Text &#91;required&#93; A UTF-8 text string containing the clinical content being examined for
#' entities. Each string must contain fewer than 20,000 bytes of
#' characters.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_detect_entities
comprehendmedical_detect_entities <- function(Text) {
  op <- new_operation(
    name = "DetectEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$detect_entities_input(Text = Text)
  output <- .comprehendmedical$detect_entities_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$detect_entities <- comprehendmedical_detect_entities

#' Inspects the clinical text for a variety of medical entities and returns
#' specific information about them such as entity category, location, and
#' confidence score on that information
#'
#' @description
#' Inspects the clinical text for a variety of medical entities and returns specific information about them such as entity category, location, and confidence score on that information. Amazon Comprehend Medical only detects medical entities in English language texts.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/detect_entities_v2.html](https://paws-r.github.io/docs/comprehendmedical/detect_entities_v2.html) for full documentation.
#'
#' @param Text &#91;required&#93; A UTF-8 string containing the clinical content being examined for
#' entities. Each string must contain fewer than 20,000 bytes of
#' characters.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_detect_entities_v2
comprehendmedical_detect_entities_v2 <- function(Text) {
  op <- new_operation(
    name = "DetectEntitiesV2",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$detect_entities_v2_input(Text = Text)
  output <- .comprehendmedical$detect_entities_v2_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$detect_entities_v2 <- comprehendmedical_detect_entities_v2

#' Inspects the clinical text for protected health information (PHI)
#' entities and returns the entity category, location, and confidence score
#' for each entity
#'
#' @description
#' Inspects the clinical text for protected health information (PHI) entities and returns the entity category, location, and confidence score for each entity. Amazon Comprehend Medical only detects entities in English language texts.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/detect_phi.html](https://paws-r.github.io/docs/comprehendmedical/detect_phi.html) for full documentation.
#'
#' @param Text &#91;required&#93; A UTF-8 text string containing the clinical content being examined for
#' PHI entities. Each string must contain fewer than 20,000 bytes of
#' characters.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_detect_phi
comprehendmedical_detect_phi <- function(Text) {
  op <- new_operation(
    name = "DetectPHI",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$detect_phi_input(Text = Text)
  output <- .comprehendmedical$detect_phi_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$detect_phi <- comprehendmedical_detect_phi

#' InferICD10CM detects medical conditions as entities listed in a patient
#' record and links those entities to normalized concept identifiers in the
#' ICD-10-CM knowledge base from the Centers for Disease Control
#'
#' @description
#' InferICD10CM detects medical conditions as entities listed in a patient record and links those entities to normalized concept identifiers in the ICD-10-CM knowledge base from the Centers for Disease Control. Amazon Comprehend Medical only detects medical entities in English language texts.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/infer_icd10cm.html](https://paws-r.github.io/docs/comprehendmedical/infer_icd10cm.html) for full documentation.
#'
#' @param Text &#91;required&#93; The input text used for analysis. The input for InferICD10CM is a string
#' from 1 to 10000 characters.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_infer_icd10cm
comprehendmedical_infer_icd10cm <- function(Text) {
  op <- new_operation(
    name = "InferICD10CM",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$infer_icd10cm_input(Text = Text)
  output <- .comprehendmedical$infer_icd10cm_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$infer_icd10cm <- comprehendmedical_infer_icd10cm

#' InferRxNorm detects medications as entities listed in a patient record
#' and links to the normalized concept identifiers in the RxNorm database
#' from the National Library of Medicine
#'
#' @description
#' InferRxNorm detects medications as entities listed in a patient record and links to the normalized concept identifiers in the RxNorm database from the National Library of Medicine. Amazon Comprehend Medical only detects medical entities in English language texts.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/infer_rx_norm.html](https://paws-r.github.io/docs/comprehendmedical/infer_rx_norm.html) for full documentation.
#'
#' @param Text &#91;required&#93; The input text used for analysis. The input for InferRxNorm is a string
#' from 1 to 10000 characters.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_infer_rx_norm
comprehendmedical_infer_rx_norm <- function(Text) {
  op <- new_operation(
    name = "InferRxNorm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$infer_rx_norm_input(Text = Text)
  output <- .comprehendmedical$infer_rx_norm_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$infer_rx_norm <- comprehendmedical_infer_rx_norm

#' InferSNOMEDCT detects possible medical concepts as entities and links
#' them to codes from the Systematized Nomenclature of Medicine, Clinical
#' Terms (SNOMED-CT) ontology
#'
#' @description
#' InferSNOMEDCT detects possible medical concepts as entities and links them to codes from the Systematized Nomenclature of Medicine, Clinical Terms (SNOMED-CT) ontology
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/infer_snomedct.html](https://paws-r.github.io/docs/comprehendmedical/infer_snomedct.html) for full documentation.
#'
#' @param Text &#91;required&#93; The input text to be analyzed using InferSNOMEDCT. The text should be a
#' string with 1 to 10000 characters.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_infer_snomedct
comprehendmedical_infer_snomedct <- function(Text) {
  op <- new_operation(
    name = "InferSNOMEDCT",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$infer_snomedct_input(Text = Text)
  output <- .comprehendmedical$infer_snomedct_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$infer_snomedct <- comprehendmedical_infer_snomedct

#' Gets a list of medical entity detection jobs that you have submitted
#'
#' @description
#' Gets a list of medical entity detection jobs that you have submitted.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/list_entities_detection_v2_jobs.html](https://paws-r.github.io/docs/comprehendmedical/list_entities_detection_v2_jobs.html) for full documentation.
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs based on their
#' names, status, or the date and time that they were submitted. You can
#' only set one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_list_entities_detection_v2_jobs
comprehendmedical_list_entities_detection_v2_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEntitiesDetectionV2Jobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$list_entities_detection_v2_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehendmedical$list_entities_detection_v2_jobs_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$list_entities_detection_v2_jobs <- comprehendmedical_list_entities_detection_v2_jobs

#' Gets a list of InferICD10CM jobs that you have submitted
#'
#' @description
#' Gets a list of InferICD10CM jobs that you have submitted.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/list_icd10cm_inference_jobs.html](https://paws-r.github.io/docs/comprehendmedical/list_icd10cm_inference_jobs.html) for full documentation.
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs based on their
#' names, status, or the date and time that they were submitted. You can
#' only set one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_list_icd10cm_inference_jobs
comprehendmedical_list_icd10cm_inference_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListICD10CMInferenceJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$list_icd10cm_inference_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehendmedical$list_icd10cm_inference_jobs_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$list_icd10cm_inference_jobs <- comprehendmedical_list_icd10cm_inference_jobs

#' Gets a list of protected health information (PHI) detection jobs that
#' you have submitted
#'
#' @description
#' Gets a list of protected health information (PHI) detection jobs that you have submitted.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/list_phi_detection_jobs.html](https://paws-r.github.io/docs/comprehendmedical/list_phi_detection_jobs.html) for full documentation.
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs based on their
#' names, status, or the date and time that they were submitted. You can
#' only set one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_list_phi_detection_jobs
comprehendmedical_list_phi_detection_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPHIDetectionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$list_phi_detection_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehendmedical$list_phi_detection_jobs_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$list_phi_detection_jobs <- comprehendmedical_list_phi_detection_jobs

#' Gets a list of InferRxNorm jobs that you have submitted
#'
#' @description
#' Gets a list of InferRxNorm jobs that you have submitted.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/list_rx_norm_inference_jobs.html](https://paws-r.github.io/docs/comprehendmedical/list_rx_norm_inference_jobs.html) for full documentation.
#'
#' @param Filter Filters the jobs that are returned. You can filter jobs based on their
#' names, status, or the date and time that they were submitted. You can
#' only set one filter at a time.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults Identifies the next page of results to return.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_list_rx_norm_inference_jobs
comprehendmedical_list_rx_norm_inference_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRxNormInferenceJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$list_rx_norm_inference_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehendmedical$list_rx_norm_inference_jobs_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$list_rx_norm_inference_jobs <- comprehendmedical_list_rx_norm_inference_jobs

#' Gets a list of InferSNOMEDCT jobs a user has submitted
#'
#' @description
#' Gets a list of InferSNOMEDCT jobs a user has submitted.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/list_snomedct_inference_jobs.html](https://paws-r.github.io/docs/comprehendmedical/list_snomedct_inference_jobs.html) for full documentation.
#'
#' @param Filter 
#' @param NextToken Identifies the next page of InferSNOMEDCT results to return.
#' @param MaxResults The maximum number of results to return in each page. The default is
#' 100.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_list_snomedct_inference_jobs
comprehendmedical_list_snomedct_inference_jobs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSNOMEDCTInferenceJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$list_snomedct_inference_jobs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .comprehendmedical$list_snomedct_inference_jobs_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$list_snomedct_inference_jobs <- comprehendmedical_list_snomedct_inference_jobs

#' Starts an asynchronous medical entity detection job for a collection of
#' documents
#'
#' @description
#' Starts an asynchronous medical entity detection job for a collection of documents. Use the [`describe_entities_detection_v2_job`][comprehendmedical_describe_entities_detection_v2_job] operation to track the status of a job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/start_entities_detection_v2_job.html](https://paws-r.github.io/docs/comprehendmedical/start_entities_detection_v2_job.html) for full documentation.
#'
#' @param InputDataConfig &#91;required&#93; The input configuration that specifies the format and location of the
#' input data for the job.
#' @param OutputDataConfig &#91;required&#93; The output configuration that specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Comprehend Medical; read access to your input
#' data. For more information, see [Role-Based Permissions Required for
#' Asynchronous
#' Operations](https://docs.aws.amazon.com/comprehend-medical/latest/dev/security-iam-permissions.html#auth-role-permissions-med).
#' @param JobName The identifier of the job.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Comprehend Medical; generates one for you.
#' @param KMSKey An AWS Key Management Service key to encrypt your output files. If you
#' do not specify a key, the files are written in plain text.
#' @param LanguageCode &#91;required&#93; The language of the input documents. All documents must be in the same
#' language. Comprehend Medical; processes files in US English (en).
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_start_entities_detection_v2_job
comprehendmedical_start_entities_detection_v2_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, ClientRequestToken = NULL, KMSKey = NULL, LanguageCode) {
  op <- new_operation(
    name = "StartEntitiesDetectionV2Job",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$start_entities_detection_v2_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, ClientRequestToken = ClientRequestToken, KMSKey = KMSKey, LanguageCode = LanguageCode)
  output <- .comprehendmedical$start_entities_detection_v2_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$start_entities_detection_v2_job <- comprehendmedical_start_entities_detection_v2_job

#' Starts an asynchronous job to detect medical conditions and link them to
#' the ICD-10-CM ontology
#'
#' @description
#' Starts an asynchronous job to detect medical conditions and link them to the ICD-10-CM ontology. Use the [`describe_icd10cm_inference_job`][comprehendmedical_describe_icd10cm_inference_job] operation to track the status of a job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/start_icd10cm_inference_job.html](https://paws-r.github.io/docs/comprehendmedical/start_icd10cm_inference_job.html) for full documentation.
#'
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Comprehend Medical; read access to your input
#' data. For more information, see [Role-Based Permissions Required for
#' Asynchronous
#' Operations](https://docs.aws.amazon.com/comprehend-medical/latest/dev/security-iam-permissions.html#auth-role-permissions-med).
#' @param JobName The identifier of the job.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Comprehend Medical; generates one.
#' @param KMSKey An AWS Key Management Service key to encrypt your output files. If you
#' do not specify a key, the files are written in plain text.
#' @param LanguageCode &#91;required&#93; The language of the input documents. All documents must be in the same
#' language.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_start_icd10cm_inference_job
comprehendmedical_start_icd10cm_inference_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, ClientRequestToken = NULL, KMSKey = NULL, LanguageCode) {
  op <- new_operation(
    name = "StartICD10CMInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$start_icd10cm_inference_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, ClientRequestToken = ClientRequestToken, KMSKey = KMSKey, LanguageCode = LanguageCode)
  output <- .comprehendmedical$start_icd10cm_inference_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$start_icd10cm_inference_job <- comprehendmedical_start_icd10cm_inference_job

#' Starts an asynchronous job to detect protected health information (PHI)
#'
#' @description
#' Starts an asynchronous job to detect protected health information (PHI). Use the [`describe_phi_detection_job`][comprehendmedical_describe_phi_detection_job] operation to track the status of a job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/start_phi_detection_job.html](https://paws-r.github.io/docs/comprehendmedical/start_phi_detection_job.html) for full documentation.
#'
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Comprehend Medical; read access to your input
#' data. For more information, see [Role-Based Permissions Required for
#' Asynchronous
#' Operations](https://docs.aws.amazon.com/comprehend-medical/latest/dev/security-iam-permissions.html#auth-role-permissions-med).
#' @param JobName The identifier of the job.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Comprehend Medical; generates one.
#' @param KMSKey An AWS Key Management Service key to encrypt your output files. If you
#' do not specify a key, the files are written in plain text.
#' @param LanguageCode &#91;required&#93; The language of the input documents. All documents must be in the same
#' language.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_start_phi_detection_job
comprehendmedical_start_phi_detection_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, ClientRequestToken = NULL, KMSKey = NULL, LanguageCode) {
  op <- new_operation(
    name = "StartPHIDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$start_phi_detection_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, ClientRequestToken = ClientRequestToken, KMSKey = KMSKey, LanguageCode = LanguageCode)
  output <- .comprehendmedical$start_phi_detection_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$start_phi_detection_job <- comprehendmedical_start_phi_detection_job

#' Starts an asynchronous job to detect medication entities and link them
#' to the RxNorm ontology
#'
#' @description
#' Starts an asynchronous job to detect medication entities and link them to the RxNorm ontology. Use the [`describe_rx_norm_inference_job`][comprehendmedical_describe_rx_norm_inference_job] operation to track the status of a job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/start_rx_norm_inference_job.html](https://paws-r.github.io/docs/comprehendmedical/start_rx_norm_inference_job.html) for full documentation.
#'
#' @param InputDataConfig &#91;required&#93; Specifies the format and location of the input data for the job.
#' @param OutputDataConfig &#91;required&#93; Specifies where to send the output files.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Comprehend Medical; read access to your input
#' data. For more information, see [Role-Based Permissions Required for
#' Asynchronous
#' Operations](https://docs.aws.amazon.com/comprehend-medical/latest/dev/security-iam-permissions.html#auth-role-permissions-med).
#' @param JobName The identifier of the job.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Comprehend Medical; generates one.
#' @param KMSKey An AWS Key Management Service key to encrypt your output files. If you
#' do not specify a key, the files are written in plain text.
#' @param LanguageCode &#91;required&#93; The language of the input documents. All documents must be in the same
#' language.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_start_rx_norm_inference_job
comprehendmedical_start_rx_norm_inference_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, ClientRequestToken = NULL, KMSKey = NULL, LanguageCode) {
  op <- new_operation(
    name = "StartRxNormInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$start_rx_norm_inference_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, ClientRequestToken = ClientRequestToken, KMSKey = KMSKey, LanguageCode = LanguageCode)
  output <- .comprehendmedical$start_rx_norm_inference_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$start_rx_norm_inference_job <- comprehendmedical_start_rx_norm_inference_job

#' Starts an asynchronous job to detect medical concepts and link them to
#' the SNOMED-CT ontology
#'
#' @description
#' Starts an asynchronous job to detect medical concepts and link them to the SNOMED-CT ontology. Use the DescribeSNOMEDCTInferenceJob operation to track the status of a job.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/start_snomedct_inference_job.html](https://paws-r.github.io/docs/comprehendmedical/start_snomedct_inference_job.html) for full documentation.
#'
#' @param InputDataConfig &#91;required&#93; 
#' @param OutputDataConfig &#91;required&#93; 
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that grants Amazon Comprehend Medical read access to your
#' input data.
#' @param JobName The user generated name the asynchronous InferSNOMEDCT job.
#' @param ClientRequestToken A unique identifier for the request. If you don't set the client request
#' token, Amazon Comprehend Medical generates one.
#' @param KMSKey An AWS Key Management Service key used to encrypt your output files. If
#' you do not specify a key, the files are written in plain text.
#' @param LanguageCode &#91;required&#93; The language of the input documents. All documents must be in the same
#' language.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_start_snomedct_inference_job
comprehendmedical_start_snomedct_inference_job <- function(InputDataConfig, OutputDataConfig, DataAccessRoleArn, JobName = NULL, ClientRequestToken = NULL, KMSKey = NULL, LanguageCode) {
  op <- new_operation(
    name = "StartSNOMEDCTInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$start_snomedct_inference_job_input(InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, DataAccessRoleArn = DataAccessRoleArn, JobName = JobName, ClientRequestToken = ClientRequestToken, KMSKey = KMSKey, LanguageCode = LanguageCode)
  output <- .comprehendmedical$start_snomedct_inference_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$start_snomedct_inference_job <- comprehendmedical_start_snomedct_inference_job

#' Stops a medical entities detection job in progress
#'
#' @description
#' Stops a medical entities detection job in progress.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/stop_entities_detection_v2_job.html](https://paws-r.github.io/docs/comprehendmedical/stop_entities_detection_v2_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier of the medical entities job to stop.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_stop_entities_detection_v2_job
comprehendmedical_stop_entities_detection_v2_job <- function(JobId) {
  op <- new_operation(
    name = "StopEntitiesDetectionV2Job",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$stop_entities_detection_v2_job_input(JobId = JobId)
  output <- .comprehendmedical$stop_entities_detection_v2_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$stop_entities_detection_v2_job <- comprehendmedical_stop_entities_detection_v2_job

#' Stops an InferICD10CM inference job in progress
#'
#' @description
#' Stops an InferICD10CM inference job in progress.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/stop_icd10cm_inference_job.html](https://paws-r.github.io/docs/comprehendmedical/stop_icd10cm_inference_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier of the job.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_stop_icd10cm_inference_job
comprehendmedical_stop_icd10cm_inference_job <- function(JobId) {
  op <- new_operation(
    name = "StopICD10CMInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$stop_icd10cm_inference_job_input(JobId = JobId)
  output <- .comprehendmedical$stop_icd10cm_inference_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$stop_icd10cm_inference_job <- comprehendmedical_stop_icd10cm_inference_job

#' Stops a protected health information (PHI) detection job in progress
#'
#' @description
#' Stops a protected health information (PHI) detection job in progress.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/stop_phi_detection_job.html](https://paws-r.github.io/docs/comprehendmedical/stop_phi_detection_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier of the PHI detection job to stop.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_stop_phi_detection_job
comprehendmedical_stop_phi_detection_job <- function(JobId) {
  op <- new_operation(
    name = "StopPHIDetectionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$stop_phi_detection_job_input(JobId = JobId)
  output <- .comprehendmedical$stop_phi_detection_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$stop_phi_detection_job <- comprehendmedical_stop_phi_detection_job

#' Stops an InferRxNorm inference job in progress
#'
#' @description
#' Stops an InferRxNorm inference job in progress.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/stop_rx_norm_inference_job.html](https://paws-r.github.io/docs/comprehendmedical/stop_rx_norm_inference_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier of the job.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_stop_rx_norm_inference_job
comprehendmedical_stop_rx_norm_inference_job <- function(JobId) {
  op <- new_operation(
    name = "StopRxNormInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$stop_rx_norm_inference_job_input(JobId = JobId)
  output <- .comprehendmedical$stop_rx_norm_inference_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$stop_rx_norm_inference_job <- comprehendmedical_stop_rx_norm_inference_job

#' Stops an InferSNOMEDCT inference job in progress
#'
#' @description
#' Stops an InferSNOMEDCT inference job in progress.
#'
#' See [https://paws-r.github.io/docs/comprehendmedical/stop_snomedct_inference_job.html](https://paws-r.github.io/docs/comprehendmedical/stop_snomedct_inference_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The job id of the asynchronous InferSNOMEDCT job to be stopped.
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_stop_snomedct_inference_job
comprehendmedical_stop_snomedct_inference_job <- function(JobId) {
  op <- new_operation(
    name = "StopSNOMEDCTInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$stop_snomedct_inference_job_input(JobId = JobId)
  output <- .comprehendmedical$stop_snomedct_inference_job_output()
  config <- get_config()
  svc <- .comprehendmedical$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$stop_snomedct_inference_job <- comprehendmedical_stop_snomedct_inference_job
