% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_put_bot_alias}
\alias{lexmodelbuildingservice_put_bot_alias}
\title{Creates an alias for the specified version of the bot or replaces an
alias for the specified bot}
\usage{
lexmodelbuildingservice_put_bot_alias(name, description, botVersion,
  botName, checksum)
}
\arguments{
\item{name}{[required] The name of the alias. The name is \emph{not} case sensitive.}

\item{description}{A description of the alias.}

\item{botVersion}{[required] The version of the bot.}

\item{botName}{[required] The name of the bot.}

\item{checksum}{Identifies a specific revision of the \code{$LATEST} version.

When you create a new bot alias, leave the \code{checksum} field blank. If
you specify a checksum you get a \code{BadRequestException} exception.

When you want to update a bot alias, set the \code{checksum} field to the
checksum of the most recent revision of the \code{$LATEST} version. If you
don't specify the \code{ checksum} field, or if the checksum does not match
the \code{$LATEST} version, you get a \code{PreconditionFailedException}
exception.}
}
\description{
Creates an alias for the specified version of the bot or replaces an
alias for the specified bot. To change the version of the bot that the
alias points to, replace the alias. For more information about aliases,
see versioning-aliases.
}
\details{
This operation requires permissions for the \code{lex:PutBotAlias} action.
}
\section{Request syntax}{
\preformatted{svc$put_bot_alias(
  name = "string",
  description = "string",
  botVersion = "string",
  botName = "string",
  checksum = "string"
)
}
}

\keyword{internal}
