# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Transcribe Service
#'
#' @description
#' Operations and objects for transcribing speech to text.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- transcribeservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- transcribeservice()
#' svc$create_language_model(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=transcribeservice_create_language_model]{create_language_model} \tab Creates a new custom language model\cr
#'  \link[=transcribeservice_create_medical_vocabulary]{create_medical_vocabulary} \tab Creates a new custom vocabulary that you can use to change how Amazon Transcribe Medical transcribes your audio file\cr
#'  \link[=transcribeservice_create_vocabulary]{create_vocabulary} \tab Creates a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file\cr
#'  \link[=transcribeservice_create_vocabulary_filter]{create_vocabulary_filter} \tab Creates a new vocabulary filter that you can use to filter words, such as profane words, from the output of a transcription job\cr
#'  \link[=transcribeservice_delete_language_model]{delete_language_model} \tab Deletes a custom language model using its name\cr
#'  \link[=transcribeservice_delete_medical_transcription_job]{delete_medical_transcription_job} \tab Deletes a transcription job generated by Amazon Transcribe Medical and any related information\cr
#'  \link[=transcribeservice_delete_medical_vocabulary]{delete_medical_vocabulary} \tab Deletes a vocabulary from Amazon Transcribe Medical\cr
#'  \link[=transcribeservice_delete_transcription_job]{delete_transcription_job} \tab Deletes a previously submitted transcription job along with any other generated results such as the transcription, models, and so on\cr
#'  \link[=transcribeservice_delete_vocabulary]{delete_vocabulary} \tab Deletes a vocabulary from Amazon Transcribe\cr
#'  \link[=transcribeservice_delete_vocabulary_filter]{delete_vocabulary_filter} \tab Removes a vocabulary filter\cr
#'  \link[=transcribeservice_describe_language_model]{describe_language_model} \tab Gets information about a single custom language model\cr
#'  \link[=transcribeservice_get_medical_transcription_job]{get_medical_transcription_job} \tab Returns information about a transcription job from Amazon Transcribe Medical\cr
#'  \link[=transcribeservice_get_medical_vocabulary]{get_medical_vocabulary} \tab Retrieves information about a medical vocabulary\cr
#'  \link[=transcribeservice_get_transcription_job]{get_transcription_job} \tab Returns information about a transcription job\cr
#'  \link[=transcribeservice_get_vocabulary]{get_vocabulary} \tab Gets information about a vocabulary\cr
#'  \link[=transcribeservice_get_vocabulary_filter]{get_vocabulary_filter} \tab Returns information about a vocabulary filter\cr
#'  \link[=transcribeservice_list_language_models]{list_language_models} \tab Provides more information about the custom language models you've created\cr
#'  \link[=transcribeservice_list_medical_transcription_jobs]{list_medical_transcription_jobs} \tab Lists medical transcription jobs with a specified status or substring that matches their names\cr
#'  \link[=transcribeservice_list_medical_vocabularies]{list_medical_vocabularies} \tab Returns a list of vocabularies that match the specified criteria\cr
#'  \link[=transcribeservice_list_transcription_jobs]{list_transcription_jobs} \tab Lists transcription jobs with the specified status\cr
#'  \link[=transcribeservice_list_vocabularies]{list_vocabularies} \tab Returns a list of vocabularies that match the specified criteria\cr
#'  \link[=transcribeservice_list_vocabulary_filters]{list_vocabulary_filters} \tab Gets information about vocabulary filters\cr
#'  \link[=transcribeservice_start_medical_transcription_job]{start_medical_transcription_job} \tab Starts a batch job to transcribe medical speech to text\cr
#'  \link[=transcribeservice_start_transcription_job]{start_transcription_job} \tab Starts an asynchronous job to transcribe speech to text\cr
#'  \link[=transcribeservice_update_medical_vocabulary]{update_medical_vocabulary} \tab Updates a vocabulary with new values that you provide in a different text file from the one you used to create the vocabulary\cr
#'  \link[=transcribeservice_update_vocabulary]{update_vocabulary} \tab Updates an existing vocabulary with new values\cr
#'  \link[=transcribeservice_update_vocabulary_filter]{update_vocabulary_filter} \tab Updates a vocabulary filter with a new list of filtered words
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname transcribeservice
#' @export
transcribeservice <- function(config = list()) {
  svc <- .transcribeservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.transcribeservice <- list()

.transcribeservice$operations <- list()

.transcribeservice$metadata <- list(
  service_name = "transcribe",
  endpoints = list("*" = list(endpoint = "transcribe.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "transcribe.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "transcribe.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "transcribe.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Transcribe",
  api_version = "2017-10-26",
  signing_name = "transcribe",
  json_version = "1.1",
  target_prefix = "Transcribe"
)

.transcribeservice$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.transcribeservice$metadata, handlers, config)
}
