% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_slot_types}
\alias{lexmodelbuildingservice_get_slot_types}
\title{Returns slot type information as follows: - If you specify the
nameContains field, returns the $LATEST version of all slot types that
contain the specified string}
\usage{
lexmodelbuildingservice_get_slot_types(nextToken, maxResults,
  nameContains)
}
\arguments{
\item{nextToken}{A pagination token that fetches the next page of slot types. If the
response to this API call is truncated, Amazon Lex returns a pagination
token in the response. To fetch next page of slot types, specify the
pagination token in the next request.}

\item{maxResults}{The maximum number of slot types to return in the response. The default
is 10.}

\item{nameContains}{Substring to match in slot type names. A slot type will be returned if
any part of its name matches the substring. For example, "xyz" matches
both "xyzabc" and "abcxyz."}
}
\description{
Returns slot type information as follows:
\itemize{
\item If you specify the \code{nameContains} field, returns the \verb{$LATEST}
version of all slot types that contain the specified string.
\item If you don't specify the \code{nameContains} field, returns information
about the \verb{$LATEST} version of all slot types.
}

The operation requires permission for the \code{lex:GetSlotTypes} action.
}
\section{Request syntax}{
\preformatted{svc$get_slot_types(
  nextToken = "string",
  maxResults = 123,
  nameContains = "string"
)
}
}

\examples{
\dontrun{
# This example shows how to get a list of all of the slot types in your
# account.
svc$get_slot_types(
  maxResults = 10L,
  nextToken = ""
)
}

}
\keyword{internal}
