% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_update_vocabulary}
\alias{transcribeservice_update_vocabulary}
\title{Updates an existing vocabulary with new values}
\usage{
transcribeservice_update_vocabulary(VocabularyName, LanguageCode,
  Phrases, VocabularyFileUri)
}
\arguments{
\item{VocabularyName}{[required] The name of the vocabulary to update. The name is case-sensitive.}

\item{LanguageCode}{[required] The language code of the vocabulary entries.}

\item{Phrases}{An array of strings containing the vocabulary entries.}

\item{VocabularyFileUri}{The S3 location of the text file that contains the definition of the
custom vocabulary. The URI must be in the same region as the API
endpoint that you are calling. The general form is

\code{https://s3-&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt;}

For example:

\code{https://s3-us-east-1.amazonaws.com/examplebucket/vocab.txt}

For more information about S3 object names, see \href{http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys}{Object Keys}
in the \emph{Amazon S3 Developer Guide}.

For more information about custom vocabularies, see \href{http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary}{Custom Vocabularies}.}
}
\description{
Updates an existing vocabulary with new values. The \code{UpdateVocabulary}
operation overwrites all of the existing information with the values
that you provide in the request.
}
\section{Request syntax}{
\preformatted{svc$update_vocabulary(
  VocabularyName = "string",
  LanguageCode = "en-US"|"es-US"|"en-AU"|"fr-CA"|"en-GB"|"de-DE"|"pt-BR"|"fr-FR"|"it-IT"|"ko-KR",
  Phrases = list(
    "string"
  ),
  VocabularyFileUri = "string"
)
}
}

\keyword{internal}
