% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemakerruntime_operations.R
\name{sagemakerruntime_invoke_endpoint}
\alias{sagemakerruntime_invoke_endpoint}
\title{After you deploy a model into production using Amazon SageMaker hosting
services, your client applications use this API to get inferences from
the model hosted at the specified endpoint}
\usage{
sagemakerruntime_invoke_endpoint(EndpointName, Body, ContentType,
  Accept, CustomAttributes)
}
\arguments{
\item{EndpointName}{[required] The name of the endpoint that you specified when you created the
endpoint using the
\href{http://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html}{CreateEndpoint}
API.}

\item{Body}{[required] Provides input data, in the format specified in the \code{ContentType}
request header. Amazon SageMaker passes all of the data in the body to
the model.

For information about the format of the request body, see \href{http://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html}{Common Data Formats---Inference}.}

\item{ContentType}{The MIME type of the input data in the request body.}

\item{Accept}{The desired MIME type of the inference in the response.}

\item{CustomAttributes}{}
}
\description{
After you deploy a model into production using Amazon SageMaker hosting
services, your client applications use this API to get inferences from
the model hosted at the specified endpoint.
}
\details{
For an overview of Amazon SageMaker, see \href{http://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html}{How It Works}.

Amazon SageMaker strips all POST headers except those supported by the
API. Amazon SageMaker might add additional headers. You should not rely
on the behavior of headers outside those enumerated in the request
syntax.

Cals to \code{InvokeEndpoint} are authenticated by using AWS Signature
Version 4. For information, see \href{http://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html}{Authenticating Requests (AWS Signature Version 4)}
in the \emph{Amazon S3 API Reference}.

Endpoints are scoped to an individual account, and are not public. The
URL does not contain the account ID, but Amazon SageMaker determines the
account ID from the authentication token that is supplied by the caller.
}
\section{Request syntax}{
\preformatted{svc$invoke_endpoint(
  EndpointName = "string",
  Body = raw,
  ContentType = "string",
  Accept = "string",
  CustomAttributes = "string"
)
}
}

\keyword{internal}
