# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include workmailmessageflow_service.R
NULL

#' Retrieves the raw content of an in-transit email message, in MIME format
#'
#' @description
#' Retrieves the raw content of an in-transit email message, in MIME format.
#'
#' See [https://www.paws-r-sdk.com/docs/workmailmessageflow_get_raw_message_content/](https://www.paws-r-sdk.com/docs/workmailmessageflow_get_raw_message_content/) for full documentation.
#'
#' @param messageId &#91;required&#93; The identifier of the email message to retrieve.
#'
#' @keywords internal
#'
#' @rdname workmailmessageflow_get_raw_message_content
workmailmessageflow_get_raw_message_content <- function(messageId) {
  op <- new_operation(
    name = "GetRawMessageContent",
    http_method = "GET",
    http_path = "/messages/{messageId}",
    paginator = list()
  )
  input <- .workmailmessageflow$get_raw_message_content_input(messageId = messageId)
  output <- .workmailmessageflow$get_raw_message_content_output()
  config <- get_config()
  svc <- .workmailmessageflow$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmailmessageflow$operations$get_raw_message_content <- workmailmessageflow_get_raw_message_content

#' Updates the raw content of an in-transit email message, in MIME format
#'
#' @description
#' Updates the raw content of an in-transit email message, in MIME format.
#'
#' See [https://www.paws-r-sdk.com/docs/workmailmessageflow_put_raw_message_content/](https://www.paws-r-sdk.com/docs/workmailmessageflow_put_raw_message_content/) for full documentation.
#'
#' @param messageId &#91;required&#93; The identifier of the email message being updated.
#' @param content &#91;required&#93; Describes the raw message content of the updated email message.
#'
#' @keywords internal
#'
#' @rdname workmailmessageflow_put_raw_message_content
workmailmessageflow_put_raw_message_content <- function(messageId, content) {
  op <- new_operation(
    name = "PutRawMessageContent",
    http_method = "POST",
    http_path = "/messages/{messageId}",
    paginator = list()
  )
  input <- .workmailmessageflow$put_raw_message_content_input(messageId = messageId, content = content)
  output <- .workmailmessageflow$put_raw_message_content_output()
  config <- get_config()
  svc <- .workmailmessageflow$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmailmessageflow$operations$put_raw_message_content <- workmailmessageflow_put_raw_message_content
